#include "soviet.h"

uint8_t sv_blockarea[sv_size_x][sv_size_y];
uint8_t sv_nextarea[4][4];

void sv_init() {
  uint16_t i = 0;
  uint16_t j = 0;
  for (i = 0; i < sv_size_x; i++) {
    for (j = 0; j < sv_size_y; j++) {
      sv_blockarea[i][j] = 0;
    }
  }
}

bool sv_is_gameover = 0;
int sv_level = 0;            // sv_LEVEL decreases frame drop from sv_level0_frames frames to 0 frames (sv_levels
unsigned int sv_lines = 0;   // NUMBER OF sv_LINES CLEARED
unsigned long sv_score = 0;  // TOTAL sv_SCORE (using NES rules)

bool sv_up_b = 0;
bool sv_down_b = 0;
bool sv_left_b = 0;
bool sv_right_b = 0;
bool sv_rcw_b = 0;
bool sv_rccw_b = 0;
bool sv_newgame_b = 1;

void sv_up() { sv_up_b = 1; }
void sv_down() { sv_down_b = 1; }
void sv_left() { sv_left_b = 1; }
void sv_right() { sv_right_b = 1; }
void sv_rcw() { sv_rcw_b = 1; }
void sv_rccw() { sv_rccw_b = 1; }

void sv_newgame() { sv_newgame_b = 1; }

#define pfsizeX sv_size_x
#define pfsizeY sv_size_y + 4  // note that top 4 sv_lines are not drawn

#define pfX 8  // upper left corner of sv_playfield location (pixel)
#define pfY 3
#define npX 60  // upper left corner of next piece indicator
#define npY 2
#define clspX 2  // spacing between cell elements (pixels)
#define clspY 1

void controls(void);

uint8_t sv_playfield[pfsizeX][pfsizeY];  // the game area
uint8_t sv_pieceC[4][4];                 // piece container
int8_t sv_pieceCX;                       // location of upper left corner of piece container
int8_t sv_pieceCY;
uint8_t sv_pieceT;  // type of piece
uint8_t sv_pieceR;  // rotation of piece
uint8_t sv_nextsv_pieceT;
uint8_t sv_nextsv_pieceR;

uint8_t sv_dcontrol;  // locks in control every frame
uint8_t sv_rcontrol;

uint8_t sv_lastsv_rcontrol = 0;
bool sv_hold_down = 0;

uint8_t sv_dropframe = 0;  // counter for number of frames between block drops

bool sv_start_newgame = 1;           // when set, starts new game
bool sv_get_newpiece = 0;            // when set, get a new piece
bool sv_post_drop_hold_lockout = 0;  // when down is held, lockout drop when next piece comes

uint8_t sv_fdrop;      // number of blocks that piece has been fast dropped
uint8_t sv_lslvi = 0;  // sv_lines since sv_level increase (when this gets to 10, increase the sv_level)
int8_t sv_lvladd = 0;

uint8_t sv_piecebag[7];
uint8_t sv_piecebag_index = 7;

uint8_t sv_cleared_line[pfsizeY];
uint8_t sv_cleared_lines = 0;
uint8_t sv_lineclear_ani = 0;
uint8_t sv_lineclear_ani_frame = 0;
uint8_t sv_lines_scoring = 0;

uint8_t sv_das_counter = 0;

uint16_t sv_gravity_frames = sv_level0_frames;

void sv_nextlevel() {
  sv_level++;
  float gravity = sv_level0_frames;
  uint16_t i = 0;
  for (i = 0; i < sv_level; i++) {
    gravity *= 0.9;
  }
  if (gravity <= 1) gravity = 1;
  sv_gravity_frames = gravity;
  // printf("%i, %i\n", sv_level, sv_gravity_frames);
}

void cdraw(int8_t x, int8_t y, int8_t color) {  // only draws on screen if it needs to (uses cell coordinates)
  y = sv_size_y - 1 - y;
  if (color > 16) {
    color = 8;  // white - clearline flash
  } else if (color > 8)
    color -= 8;
  if (sv_blockarea[x][y] != color) {
    sv_blockarea[x][y] = color;
  }
}

void recopyscreen() {  // copies sv_playfield to screen
  int8_t i = 0;
  for (i = 0; i < pfsizeX; i++) {  // manually redraw the entire screen
    int8_t j = 0;
    for (j = 4; j < pfsizeY; j++) {
      cdraw(i, j - 4, sv_playfield[i][j]);
    }
  }
}
void controls() {
  if (sv_newgame_b) {
    sv_start_newgame = 1;
    sv_is_gameover = 0;
  }

  uint8_t sv_dcontrol_k = 0;
  if (sv_left_b) {
    sv_dcontrol_k = 4;
  }
  if (sv_right_b) {
    sv_dcontrol_k = 6;
  }
  if (sv_up_b) {
    sv_dcontrol_k = 8;
  }
  if (sv_down_b) {
    if (!sv_post_drop_hold_lockout) {
      sv_dcontrol_k = 2;
      sv_hold_down = 1;
    }
  } else {
    sv_post_drop_hold_lockout = 0;
    sv_hold_down = 0;
  }

  sv_dcontrol = sv_dcontrol_k;

  if (sv_dcontrol_k != 0) {
    if (sv_das_counter < sv_das_first) {
      if (sv_das_counter != 0) sv_dcontrol = 0;
      sv_das_counter++;
    } else {
      sv_das_counter = sv_das_subsequent;
    }
  } else {
    sv_das_counter = 0;
  }

  uint8_t sv_rcontrol_k = 0;
  if (sv_rccw_b) {
    sv_rcontrol_k = 1;
  }
  if (sv_rcw_b) {
    sv_rcontrol_k = 2;
  }

  if (sv_rcontrol_k != sv_lastsv_rcontrol) {
    sv_rcontrol = sv_rcontrol_k;
  } else {
    sv_rcontrol = 0;
  }
  sv_lastsv_rcontrol = sv_rcontrol_k;

  sv_up_b = 0;
  sv_down_b = 0;
  sv_left_b = 0;
  sv_right_b = 0;
  sv_rcw_b = 0;
  sv_rccw_b = 0;
  sv_newgame_b = 0;
}

void loadpiece() {  // hardcoded all pieces
  switch (sv_pieceT) {
    case 1:  // long one
      switch (sv_pieceR) {
        case 1:
        case 3:
          sv_pieceC[0][0] = 0;
          sv_pieceC[1][0] = 0;
          sv_pieceC[2][0] = 0;
          sv_pieceC[3][0] = 0;
          sv_pieceC[0][1] = 0;
          sv_pieceC[1][1] = 0;
          sv_pieceC[2][1] = 0;
          sv_pieceC[3][1] = 0;
          sv_pieceC[0][2] = 1;
          sv_pieceC[1][2] = 1;
          sv_pieceC[2][2] = 1;
          sv_pieceC[3][2] = 1;
          sv_pieceC[0][3] = 0;
          sv_pieceC[1][3] = 0;
          sv_pieceC[2][3] = 0;
          sv_pieceC[3][3] = 0;
          break;
        case 2:
        case 4:
          sv_pieceC[0][0] = 0;
          sv_pieceC[1][0] = 0;
          sv_pieceC[2][0] = 1;
          sv_pieceC[3][0] = 0;
          sv_pieceC[0][1] = 0;
          sv_pieceC[1][1] = 0;
          sv_pieceC[2][1] = 1;
          sv_pieceC[3][1] = 0;
          sv_pieceC[0][2] = 0;
          sv_pieceC[1][2] = 0;
          sv_pieceC[2][2] = 1;
          sv_pieceC[3][2] = 0;
          sv_pieceC[0][3] = 0;
          sv_pieceC[1][3] = 0;
          sv_pieceC[2][3] = 1;
          sv_pieceC[3][3] = 0;
          break;
      }
      break;
    case 2:  // backwards L
      switch (sv_pieceR) {
        case 1:
          sv_pieceC[0][0] = 0;
          sv_pieceC[1][0] = 0;
          sv_pieceC[2][0] = 0;
          sv_pieceC[3][0] = 0;
          sv_pieceC[0][1] = 0;
          sv_pieceC[1][1] = 0;
          sv_pieceC[2][1] = 0;
          sv_pieceC[3][1] = 0;
          sv_pieceC[0][2] = 2;
          sv_pieceC[1][2] = 2;
          sv_pieceC[2][2] = 2;
          sv_pieceC[3][2] = 0;
          sv_pieceC[0][3] = 0;
          sv_pieceC[1][3] = 0;
          sv_pieceC[2][3] = 2;
          sv_pieceC[3][3] = 0;
          break;
        case 2:
          sv_pieceC[0][0] = 0;
          sv_pieceC[1][0] = 0;
          sv_pieceC[2][0] = 0;
          sv_pieceC[3][0] = 0;
          sv_pieceC[0][1] = 0;
          sv_pieceC[1][1] = 2;
          sv_pieceC[2][1] = 0;
          sv_pieceC[3][1] = 0;
          sv_pieceC[0][2] = 0;
          sv_pieceC[1][2] = 2;
          sv_pieceC[2][2] = 0;
          sv_pieceC[3][2] = 0;
          sv_pieceC[0][3] = 2;
          sv_pieceC[1][3] = 2;
          sv_pieceC[2][3] = 0;
          sv_pieceC[3][3] = 0;
          break;
        case 3:
          sv_pieceC[0][0] = 0;
          sv_pieceC[1][0] = 0;
          sv_pieceC[2][0] = 0;
          sv_pieceC[3][0] = 0;
          sv_pieceC[0][1] = 2;
          sv_pieceC[1][1] = 0;
          sv_pieceC[2][1] = 0;
          sv_pieceC[3][1] = 0;
          sv_pieceC[0][2] = 2;
          sv_pieceC[1][2] = 2;
          sv_pieceC[2][2] = 2;
          sv_pieceC[3][2] = 0;
          sv_pieceC[0][3] = 0;
          sv_pieceC[1][3] = 0;
          sv_pieceC[2][3] = 0;
          sv_pieceC[3][3] = 0;
          break;
        case 4:
          sv_pieceC[0][0] = 0;
          sv_pieceC[1][0] = 0;
          sv_pieceC[2][0] = 0;
          sv_pieceC[3][0] = 0;
          sv_pieceC[0][1] = 0;
          sv_pieceC[1][1] = 2;
          sv_pieceC[2][1] = 2;
          sv_pieceC[3][1] = 0;
          sv_pieceC[0][2] = 0;
          sv_pieceC[1][2] = 2;
          sv_pieceC[2][2] = 0;
          sv_pieceC[3][2] = 0;
          sv_pieceC[0][3] = 0;
          sv_pieceC[1][3] = 2;
          sv_pieceC[2][3] = 0;
          sv_pieceC[3][3] = 0;
          break;
      }
      break;
    case 3:  // L
      switch (sv_pieceR) {
        case 1:
          sv_pieceC[0][0] = 0;
          sv_pieceC[1][0] = 0;
          sv_pieceC[2][0] = 0;
          sv_pieceC[3][0] = 0;
          sv_pieceC[0][1] = 0;
          sv_pieceC[1][1] = 0;
          sv_pieceC[2][1] = 0;
          sv_pieceC[3][1] = 0;
          sv_pieceC[0][2] = 3;
          sv_pieceC[1][2] = 3;
          sv_pieceC[2][2] = 3;
          sv_pieceC[3][2] = 0;
          sv_pieceC[0][3] = 3;
          sv_pieceC[1][3] = 0;
          sv_pieceC[2][3] = 0;
          sv_pieceC[3][3] = 0;
          break;
        case 2:
          sv_pieceC[0][0] = 0;
          sv_pieceC[1][0] = 0;
          sv_pieceC[2][0] = 0;
          sv_pieceC[3][0] = 0;
          sv_pieceC[0][1] = 3;
          sv_pieceC[1][1] = 3;
          sv_pieceC[2][1] = 0;
          sv_pieceC[3][1] = 0;
          sv_pieceC[0][2] = 0;
          sv_pieceC[1][2] = 3;
          sv_pieceC[2][2] = 0;
          sv_pieceC[3][2] = 0;
          sv_pieceC[0][3] = 0;
          sv_pieceC[1][3] = 3;
          sv_pieceC[2][3] = 0;
          sv_pieceC[3][3] = 0;
          break;
        case 3:
          sv_pieceC[0][0] = 0;
          sv_pieceC[1][0] = 0;
          sv_pieceC[2][0] = 0;
          sv_pieceC[3][0] = 0;
          sv_pieceC[0][1] = 0;
          sv_pieceC[1][1] = 0;
          sv_pieceC[2][1] = 3;
          sv_pieceC[3][1] = 0;
          sv_pieceC[0][2] = 3;
          sv_pieceC[1][2] = 3;
          sv_pieceC[2][2] = 3;
          sv_pieceC[3][2] = 0;
          sv_pieceC[0][3] = 0;
          sv_pieceC[1][3] = 0;
          sv_pieceC[2][3] = 0;
          sv_pieceC[3][3] = 0;
          break;
        case 4:
          sv_pieceC[0][0] = 0;
          sv_pieceC[1][0] = 0;
          sv_pieceC[2][0] = 0;
          sv_pieceC[3][0] = 0;
          sv_pieceC[0][1] = 0;
          sv_pieceC[1][1] = 3;
          sv_pieceC[2][1] = 0;
          sv_pieceC[3][1] = 0;
          sv_pieceC[0][2] = 0;
          sv_pieceC[1][2] = 3;
          sv_pieceC[2][2] = 0;
          sv_pieceC[3][2] = 0;
          sv_pieceC[0][3] = 0;
          sv_pieceC[1][3] = 3;
          sv_pieceC[2][3] = 3;
          sv_pieceC[3][3] = 0;
          break;
      }
      break;
    case 4:  // s shape
      switch (sv_pieceR) {
        case 1:
        case 3:
          sv_pieceC[0][0] = 0;
          sv_pieceC[1][0] = 0;
          sv_pieceC[2][0] = 0;
          sv_pieceC[3][0] = 0;
          sv_pieceC[0][1] = 0;
          sv_pieceC[1][1] = 0;
          sv_pieceC[2][1] = 0;
          sv_pieceC[3][1] = 0;
          sv_pieceC[0][2] = 0;
          sv_pieceC[1][2] = 4;
          sv_pieceC[2][2] = 4;
          sv_pieceC[3][2] = 0;
          sv_pieceC[0][3] = 4;
          sv_pieceC[1][3] = 4;
          sv_pieceC[2][3] = 0;
          sv_pieceC[3][3] = 0;
          break;
        case 2:
        case 4:
          sv_pieceC[0][0] = 0;
          sv_pieceC[1][0] = 0;
          sv_pieceC[2][0] = 0;
          sv_pieceC[3][0] = 0;
          sv_pieceC[0][1] = 0;
          sv_pieceC[1][1] = 4;
          sv_pieceC[2][1] = 0;
          sv_pieceC[3][1] = 0;
          sv_pieceC[0][2] = 0;
          sv_pieceC[1][2] = 4;
          sv_pieceC[2][2] = 4;
          sv_pieceC[3][2] = 0;
          sv_pieceC[0][3] = 0;
          sv_pieceC[1][3] = 0;
          sv_pieceC[2][3] = 4;
          sv_pieceC[3][3] = 0;
          break;
      }
      break;
    case 5:  // T shape
      switch (sv_pieceR) {
        case 1:
          sv_pieceC[0][0] = 0;
          sv_pieceC[1][0] = 0;
          sv_pieceC[2][0] = 0;
          sv_pieceC[3][0] = 0;
          sv_pieceC[0][1] = 0;
          sv_pieceC[1][1] = 0;
          sv_pieceC[2][1] = 0;
          sv_pieceC[3][1] = 0;
          sv_pieceC[0][2] = 5;
          sv_pieceC[1][2] = 5;
          sv_pieceC[2][2] = 5;
          sv_pieceC[3][2] = 0;
          sv_pieceC[0][3] = 0;
          sv_pieceC[1][3] = 5;
          sv_pieceC[2][3] = 0;
          sv_pieceC[3][3] = 0;
          break;
        case 2:
          sv_pieceC[0][0] = 0;
          sv_pieceC[1][0] = 0;
          sv_pieceC[2][0] = 0;
          sv_pieceC[3][0] = 0;
          sv_pieceC[0][1] = 0;
          sv_pieceC[1][1] = 5;
          sv_pieceC[2][1] = 0;
          sv_pieceC[3][1] = 0;
          sv_pieceC[0][2] = 5;
          sv_pieceC[1][2] = 5;
          sv_pieceC[2][2] = 0;
          sv_pieceC[3][2] = 0;
          sv_pieceC[0][3] = 0;
          sv_pieceC[1][3] = 5;
          sv_pieceC[2][3] = 0;
          sv_pieceC[3][3] = 0;
          break;
        case 3:
          sv_pieceC[0][0] = 0;
          sv_pieceC[1][0] = 0;
          sv_pieceC[2][0] = 0;
          sv_pieceC[3][0] = 0;
          sv_pieceC[0][1] = 0;
          sv_pieceC[1][1] = 5;
          sv_pieceC[2][1] = 0;
          sv_pieceC[3][1] = 0;
          sv_pieceC[0][2] = 5;
          sv_pieceC[1][2] = 5;
          sv_pieceC[2][2] = 5;
          sv_pieceC[3][2] = 0;
          sv_pieceC[0][3] = 0;
          sv_pieceC[1][3] = 0;
          sv_pieceC[2][3] = 0;
          sv_pieceC[3][3] = 0;
          break;
        case 4:
          sv_pieceC[0][0] = 0;
          sv_pieceC[1][0] = 0;
          sv_pieceC[2][0] = 0;
          sv_pieceC[3][0] = 0;
          sv_pieceC[0][1] = 0;
          sv_pieceC[1][1] = 5;
          sv_pieceC[2][1] = 0;
          sv_pieceC[3][1] = 0;
          sv_pieceC[0][2] = 0;
          sv_pieceC[1][2] = 5;
          sv_pieceC[2][2] = 5;
          sv_pieceC[3][2] = 0;
          sv_pieceC[0][3] = 0;
          sv_pieceC[1][3] = 5;
          sv_pieceC[2][3] = 0;
          sv_pieceC[3][3] = 0;
          break;
      }
      break;
    case 6:  // reverse s
      switch (sv_pieceR) {
        case 1:
        case 3:
          sv_pieceC[0][0] = 0;
          sv_pieceC[1][0] = 0;
          sv_pieceC[2][0] = 0;
          sv_pieceC[3][0] = 0;
          sv_pieceC[0][1] = 0;
          sv_pieceC[1][1] = 0;
          sv_pieceC[2][1] = 0;
          sv_pieceC[3][1] = 0;
          sv_pieceC[0][2] = 6;
          sv_pieceC[1][2] = 6;
          sv_pieceC[2][2] = 0;
          sv_pieceC[3][2] = 0;
          sv_pieceC[0][3] = 0;
          sv_pieceC[1][3] = 6;
          sv_pieceC[2][3] = 6;
          sv_pieceC[3][3] = 0;
          break;
        case 2:
        case 4:
          sv_pieceC[0][0] = 0;
          sv_pieceC[1][0] = 0;
          sv_pieceC[2][0] = 0;
          sv_pieceC[3][0] = 0;
          sv_pieceC[0][1] = 0;
          sv_pieceC[1][1] = 0;
          sv_pieceC[2][1] = 6;
          sv_pieceC[3][1] = 0;
          sv_pieceC[0][2] = 0;
          sv_pieceC[1][2] = 6;
          sv_pieceC[2][2] = 6;
          sv_pieceC[3][2] = 0;
          sv_pieceC[0][3] = 0;
          sv_pieceC[1][3] = 6;
          sv_pieceC[2][3] = 0;
          sv_pieceC[3][3] = 0;
          break;
      }
      break;
    case 7:  // square
      switch (sv_pieceR) {
        default:
          sv_pieceC[0][0] = 0;
          sv_pieceC[1][0] = 0;
          sv_pieceC[2][0] = 0;
          sv_pieceC[3][0] = 0;
          sv_pieceC[0][1] = 0;
          sv_pieceC[1][1] = 7;
          sv_pieceC[2][1] = 7;
          sv_pieceC[3][1] = 0;
          sv_pieceC[0][2] = 0;
          sv_pieceC[1][2] = 7;
          sv_pieceC[2][2] = 7;
          sv_pieceC[3][2] = 0;
          sv_pieceC[0][3] = 0;
          sv_pieceC[1][3] = 0;
          sv_pieceC[2][3] = 0;
          sv_pieceC[3][3] = 0;
          break;
      }
      break;
  }
}

uint8_t get_newpiece() {
  if (sv_piecebag_index > 6) {
    sv_piecebag[0] = 1;
    sv_piecebag[1] = 2;
    sv_piecebag[2] = 3;
    sv_piecebag[3] = 4;
    sv_piecebag[4] = 5;
    sv_piecebag[5] = 6;
    sv_piecebag[6] = 7;
    sv_piecebag_index = 0;
    uint16_t i = 0;
    for (i = 0; i < 7; i++) {
      uint8_t a = rand() % 7;
      uint8_t b = rand() % 7;
      uint8_t t = sv_piecebag[a];
      sv_piecebag[a] = sv_piecebag[b];
      sv_piecebag[b] = t;
    }
  }
  uint8_t piece = sv_piecebag[sv_piecebag_index];
  sv_piecebag_index++;
  return piece;
}

void nextpiece() {  // generate the next piece and move PC back to the top
  sv_post_drop_hold_lockout = 1;
  uint8_t tempT = sv_nextsv_pieceT;
  uint8_t tempR = sv_nextsv_pieceR;
  // sv_nextsv_pieceT = rand() % 7 + 1;
  sv_nextsv_pieceT = get_newpiece();
  sv_nextsv_pieceR = rand() % 4 + 1;
  sv_pieceT = sv_nextsv_pieceT;
  sv_pieceR = sv_nextsv_pieceR;
  loadpiece();
  int8_t i = 0;
  int8_t j = 0;
  for (i = 0; i < 4; i++) {
    for (j = 0; j < 4; j++) {
      sv_nextarea[i][3 - j] = sv_pieceC[i][j];
    }
  }

  sv_pieceT = tempT;
  sv_pieceR = tempR;

  sv_pieceCY = 0;  // move piece carrier back to the top of screen
  sv_pieceCX = 3;
}

void mdraw() {
  int8_t i = 0;
  loadpiece();               // load piece into the piece carrier
  for (i = 0; i < 6; i++) {  // check piece carrier and one block offset outside it
    int8_t j = 0;
    for (j = 0; j < 6; j++) {
      if ((sv_pieceCX - 1 + i) >= 0 && (sv_pieceCX - 1 + i) < pfsizeX && (sv_pieceCY - 1 + j) >= 4 &&
          (sv_pieceCY - 1 + j) < (pfsizeY)) {        // check if this segment be drawn on screen
        if (i >= 1 && i <= 4 && j >= 1 && j <= 4) {  // accessing piece carrier section here}
          if (sv_pieceC[i - 1][j - 1] > 0) {         // if piece carrier block is confirmed should be white
            cdraw(i - 1 + sv_pieceCX, j - 5 + sv_pieceCY, sv_pieceC[i - 1][j - 1]);
          } else {
            cdraw(i - 1 + sv_pieceCX, j - 5 + sv_pieceCY,
                  sv_playfield[i - 1 + sv_pieceCX][j - 1 + sv_pieceCY]);  // color it in with the existing sv_playfield background
          }
        } else {
          cdraw(i - 1 + sv_pieceCX, j - 5 + sv_pieceCY, sv_playfield[i - 1 + sv_pieceCX][j - 1 + sv_pieceCY]);
        }
      }
    }
  }
}

uint8_t checkCollide() {  // move the piece carrier first, then check if anything collides
  uint8_t nonvalidity = 0;
  int8_t i = 0;
  loadpiece();               // load piece into the piece carrier
  for (i = 0; i < 4; i++) {  // run through all piece carrier cells
    int8_t j = 0;
    for (j = 0; j < 4; j++) {
      if (sv_pieceCX + i >= 0 && sv_pieceCX + i < pfsizeX && sv_pieceCY + j >= 0 &&
          sv_pieceCY + j < pfsizeY) {                                                    // check if piece carrier segment can be drawn on screen
        if (sv_pieceC[i][j] != 0 && sv_playfield[i + sv_pieceCX][j + sv_pieceCY] > 7) {  // if both background and nonzero piece carrier segment collide
          nonvalidity = 1;
        }
      } else {                       // this segment of PC can't be drawn on the screen
        if (sv_pieceC[i][j] != 0) {  // a filled in segment would be drawn offscreen
          nonvalidity = 1;
        }
      }
    }
  }
  return nonvalidity;
}

void newgamemon() {
  uint8_t i = 0;
  if (sv_start_newgame == 0) {
    return;
  }
  sv_is_gameover = 0;
  sv_start_newgame = 0;
  for (i = 0; i < pfsizeX; i++) {  // clear any cells with active piece parts (will be written again with new sv_pieceC
    uint8_t j = 0;
    for (j = 0; j < pfsizeY; j++) {
      sv_playfield[i][j] = 0;
    }
  }
  sv_lines = 0;
  sv_level = 0;
  sv_score = 0;
  sv_lslvi = 0;
  sv_fdrop = 0;
  sv_gravity_frames = sv_level0_frames;
  nextpiece();
  nextpiece();
  recopyscreen();
}

void piece2bg() {  // will copy active piece into background and check for sv_lines and game over
  if (sv_lineclear_ani > 0) return;
  sv_cleared_lines = 0;
  sv_lines_scoring = 0;
  uint8_t i = 0;
  uint8_t j = 0;
  for (i = 0; i < 4; i++) {  // copy piece onto background
    uint8_t j = 0;
    for (j = 0; j < 4; j++) {
      if (sv_pieceC[i][j] != 0) {
        sv_playfield[i + sv_pieceCX][j + sv_pieceCY] = sv_pieceC[i][j] + 8;  // copy the piece into the sv_playfield/background
      }
    }
  }
  nextpiece();

  // check sv_is_gameover (scan through line 3 and see if there are any non-active pieces in it)
  for (i = 0; i < pfsizeX; i++) {
    if (sv_playfield[i][3] > 7) {
      sv_is_gameover = 1;
    }
  }

  // check for line clears
  for (j = 4; j < pfsizeY; j++) {
    sv_cleared_line[j] = 1;  // assume line is cleared
    for (i = 0; i < pfsizeX; i++) {
      if (sv_playfield[i][j] <= 7) {
        sv_cleared_line[j] = 0;  // line is not full
        break;
      }
    }
    sv_cleared_lines += sv_cleared_line[j];
    sv_lines_scoring += sv_cleared_line[j];
  }
  if (sv_cleared_lines > 0) {
    sv_lineclear_ani = 8;  // this flag tells renderer to flash lines to clear
  }
}

void sv_clearlines_score() {   // after the animation, clear the lines and do scoring
  if (sv_cleared_lines > 0) {  // breifly animate the cleared sv_lines, then clear them
    uint8_t f = 0;
    for (f = 0; f <= 4; f++) {
      uint8_t j = 4;
      for (j = 4; j < pfsizeY; j++) {
        if (sv_cleared_line[j] == 1) {
          uint8_t i = 0;
          for (i = 0; i < pfsizeX; i++) {
            cdraw(i, j - 4, f % 2);
          }
        }
      }
    }
    uint16_t j = 4;
    for (j = 4; j < pfsizeY; j++) {  // actually clear the sv_lines
      if (sv_cleared_line[j] == 1) {
        uint8_t t = 0;
        for (t = j; t >= 4; t--) {
          uint16_t i = 0;
          for (i = 0; i < pfsizeX; i++) {
            sv_playfield[i][t] = sv_playfield[i][t - 1];
          }
        }
      }
    }
    sv_lines += sv_lines_scoring;  // add number of sv_lines to sv_lines counter
    switch (sv_lines_scoring) {    // calculate sv_score
      case 1:
        sv_score += 40 * (sv_level + 1);
        break;
      case 2:
        sv_score += 100 * (sv_level + 1);
        break;
      case 3:
        sv_score += 300 * (sv_level + 1);
        break;
      default:
        sv_score += 1200 * (sv_level + 1);
        break;
    }
    uint16_t i = 1;
    for (i = 1; i <= sv_lines_scoring; i++) {  // see if the sv_level needs increasing
      sv_lslvi++;
      if (sv_lslvi >= 10) {
        sv_lslvi = 0;
        sv_nextlevel();
      }
    }
  }
  recopyscreen();
  // printf("level:%d, lines:%d, score:%ld\r\n", sv_level, sv_lines, sv_score);
}

void sv_calculate() {  // call once per frame
  controls();
  newgamemon();
  if (sv_is_gameover) return;
  uint8_t droppiece = 0;

  if (sv_lineclear_ani > 0) {  // blink lines cleared
    sv_lineclear_ani_frame++;
    if (sv_lineclear_ani_frame > sv_lineclear_ani_frameskip) {
      sv_lineclear_ani_frame = 0;
      uint16_t j = 4;
      for (j = 4; j < pfsizeY; j++) {
        if (sv_cleared_line[j] == 1) {
          uint8_t i = 0;
          for (i = 0; i < pfsizeX; i++) {
            if (!(sv_lineclear_ani & 1)) {
              sv_playfield[i][j] |= 0b10000;
            } else {
              sv_playfield[i][j] &= 0b01111;
            }
          }
        }
      }
      recopyscreen();
      sv_lineclear_ani -= 1;
      if (sv_lineclear_ani == 0) sv_clearlines_score();
    }
    return;
  }

  sv_dropframe++;
  if (sv_dropframe >= sv_gravity_frames) {
    sv_dropframe = 0;
    droppiece = 1;
  }

  if (sv_lvladd != 0) {
    sv_level += sv_lvladd;
    sv_lvladd = 0;
    recopyscreen();
  }

  if (sv_get_newpiece != 0) {
    sv_get_newpiece = 0;
    nextpiece();
    recopyscreen();
  }

  bool piece_locked = 0;
  if (sv_dcontrol == 2 || droppiece == 1) {
    sv_pieceCY++;        // try and see what happens if we move the piece down
    if (sv_hold_down) {  // is in fast mode
      sv_fdrop++;
    } else {
      sv_fdrop = 0;
    }
    if (checkCollide()) {    // piece move is not valid
      sv_pieceCY--;          // take piece back
      sv_score += sv_fdrop;  // add # of fast dropped blocks to sv_score
      sv_fdrop = 0;
      piece2bg();  // copy piece to background and reset to next piece
      piece_locked = 1;
    }
  }

  if (!piece_locked) {
    if (sv_rcontrol == 1) {
      sv_pieceR++;
      if (sv_pieceR >= 5) {
        sv_pieceR = 1;  // try to rotate piece
      }
      if (checkCollide()) {
        sv_pieceR--;
        if (sv_pieceR == 0) {
          sv_pieceR = 4;  // undo rotation
        }
      }
    }
    if (sv_rcontrol == 2) {
      sv_pieceR--;
      if (sv_pieceR == 0) {
        sv_pieceR = 4;
      }
      if (checkCollide()) {
        sv_pieceR++;
        if (sv_pieceR >= 5) {
          sv_pieceR = 1;
        }
      }
    }
    if (sv_dcontrol == 4) {
      sv_pieceCX--;          // try and see what happens if we move the piece left
      if (checkCollide()) {  // piece move is not valid
        sv_pieceCX++;        // take piece back
      }
    }
    if (sv_dcontrol == 6) {
      sv_pieceCX++;          // try and see what happens if we move the piece left
      if (checkCollide()) {  // piece move is not valid
        sv_pieceCX--;        // take piece back
      }
    }
    if (sv_dcontrol == 8) {
      sv_pieceCY--;          // try and see what happens if we move the piece up
      if (checkCollide()) {  // piece move is not valid
        sv_pieceCY++;        // take piece back
      }
    }
  }
  mdraw();
}