'source for FISHv4
DECLARE SUB mbox (a%, B%, c%, d%)
DECLARE FUNCTION Bin2Hex$ (bin$)
DECLARE FUNCTION GetPath$ ()
DECLARE FUNCTION MouseInit% ()
DECLARE FUNCTION Prompt% (showmessage%)
DECLARE SUB DrawGrids ()
DECLARE SUB MouseDriver (ax%, bx%, cx%, dx%)
DECLARE SUB MouseHide ()
DECLARE SUB MousePut (x%, y%)
DECLARE SUB MouseRange (X1%, Y1%, X2%, Y2%)
DECLARE SUB MouseSetPointer (i%)
DECLARE SUB MouseShow ()
DECLARE SUB MouseStatus (lb%, rb%, xMouse%, yMouse%)
DECLARE SUB Translate (x%, y%, in%)
DECLARE SUB WaitLetGo ()
DECLARE SUB xSET (x%, y%, clr%)
COMMON SHARED t#, dt$, gridsize%

TYPE MouseCursor
  HotSpotX AS INTEGER
  HotSpotY AS INTEGER
     Image AS STRING * 64
END TYPE

SCREEN 7

'Initialization for mouse
DIM SHARED Mouse$
Mouse$ = SPACE$(57)
FOR i% = 1 TO 57
  READ a$
  h$ = CHR$(VAL("&H" + a$))
  MID$(Mouse$, i%, 1) = h$
NEXT i%
ms% = MouseInit%
IF NOT ms% THEN
  PRINT "Mouse not found"
  SYSTEM
END IF
DIM SHARED Cursor(16) AS MouseCursor
DIM SHARED Temp AS STRING * 64
FOR i% = 0 TO 16
  READ x%, y%
  Cursor(i%).HotSpotX = x%
  Cursor(i%).HotSpotY = y%
  Cursor(i%).Image = SPACE$(64)
  FOR j% = 1 TO 64
    READ a$
    h$ = CHR$(VAL("&H" + a$))
    MID$(Cursor(i%).Image, j%, 1) = h$
  NEXT j%
NEXT i%

'Machine code for mouse routines
DATA 55,89,E5,8B,5E,0C,8B,07,50,8B,5E,0A,8B,07,50,8B
DATA 5E,08,8B,0F,8B,5E,06,8B,17,5B,58,1E,07,CD,33,53
DATA 8B,5E,0C,89,07,58,8B,5E,0A,89,07,8B,5E,08,89,0F
DATA 8B,5E,06,89,17,5D,CA,08,00

'A fiendish collection of mouse pointers just for you!
'
'The format is:
'  DATA hotspotX%, hotspotY%
'  DATA thirty-two bytes of data for the mask
'  DATA thirty-two bytes of data for the image

'Inverse mouse pointer (hs: 0,0)
DATA 0,0
DATA FF,3F,FF,1F,FF,0F,FF,07,FF,03,FF,01,FF,00,7F,00
DATA 3F,00,1F,00,FF,01,FF,10,FF,30,7F,F8,7F,F8,7F,FC
DATA 00,C0,00,A0,00,90,00,88,00,84,00,82,00,81,80,80
DATA 40,80,E0,83,00,92,00,A9,00,C9,80,04,80,04,80,03
'Inverse hourglass (hs: 5,7)
DATA 5,7
DATA 1F,00,1F,00,1F,00,3F,80,3F,80,7F,C0,FF,E0,FF,F1
DATA FF,F1,FF,E0,7F,C0,3F,80,3F,80,1F,00,1F,00,1F,00
DATA E0,FF,20,80,E0,FF,40,40,40,40,80,2A,00,15,00,0A
DATA 00,0A,00,11,80,24,40,4A,40,55,E0,FF,20,80,E0,FF
'No drop
DATA 7,7
DATA 3F,FC,0F,F0,07,E0,C3,C3,C1,8F,81,8F,18,1F,38,1E
DATA 78,1C,F8,18,F1,11,F1,83,C3,C3,07,E0,0F,F0,3F,FC
DATA C0,03,30,0C,C8,13,34,2C,2A,50,5A,50,A5,A0,45,A1
DATA 85,A2,05,A5,0A,AA,0A,54,34,2C,C8,13,30,0C,C0,03
'Paintbrush
DATA 0,14
DATA DF,FF,8F,FF,8F,FF,0F,FF,1F,FF,1F,FE,3F,FE,3F,FC
DATA 7F,FC,7F,F8,FF,F0,FF,E0,FF,C1,FF,01,FF,03,FF,07
DATA 00,00,00,00,20,00,40,00,40,00,80,00,80,00,00,01
DATA 00,01,00,02,00,02,00,08,00,1C,00,3C,00,F8,00,00
'Pencil
DATA 1,14
DATA FF,FF,FF,FF,CF,FF,87,FF,03,FF,03,FE,07,FC,0F,F8
DATA 1F,F0,3F,E0,7F,C0,FF,80,FF,01,FF,03,FF,07,FF,0F
DATA 00,00,00,00,30,00,68,00,C4,00,84,01,08,03,10,06
DATA 20,0C,40,18,80,30,00,61,00,C2,00,E4,00,B8,00,F0
'Copy
DATA 0,0
DATA FF,3F,FF,1F,FF,0F,FF,07,FF,03,FF,01,FF,00,7F,00
DATA 3F,00,1F,00,FF,01,80,10,80,30,00,F8,00,F8,00,FC
DATA 00,C0,00,A0,00,90,00,88,00,84,00,82,00,81,80,80
DATA 40,80,E0,83,00,92,7F,A9,49,C9,9D,04,89,04,BF,03
'Move
DATA 0,0
DATA FF,3F,FF,1F,FF,0F,FF,07,FF,03,FF,01,FF,00,7F,00
DATA 3F,00,1F,00,FF,01,80,10,80,30,00,F8,00,F8,00,FC
DATA 00,C0,00,A0,00,90,00,88,00,84,00,82,00,81,80,80
DATA 40,80,E0,83,00,92,7F,A9,41,C9,81,04,81,04,BF,03
'Crosshair
DATA 6,6
DATA FF,F8,FF,F8,FF,F8,FF,F8,FF,F8,07,00,07,00,07,00
DATA FF,F8,FF,F8,FF,F8,FF,F8,FF,F8,FF,FF,FF,FF,FF,FF
DATA 00,05,00,05,00,05,00,05,00,05,F8,FD,00,00,F8,FD
DATA 00,05,00,05,00,05,00,05,00,05,00,00,00,00,00,00
'Vertical Resize
DATA 4,6
DATA FF,F3,FF,E1,FF,C0,7F,80,FF,E1,FF,E1,FF,E1,FF,E1
DATA FF,E1,FF,E1,7F,80,FF,C0,FF,E1,FF,F3,FF,FF,FF,FF
DATA 00,0C,00,12,00,21,80,73,00,12,00,12,00,12,00,12
DATA 00,12,00,12,80,73,00,21,00,12,00,0C,00,00,00,00
'Horizontal Resize
DATA 6,6
DATA FF,FF,FF,FF,FF,FF,DF,EF,CF,CF,07,80,03,00,03,00
DATA 07,80,CF,CF,DF,EF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF
DATA 00,00,00,00,00,00,20,10,30,30,E8,5F,04,80,04,80
DATA E8,5F,30,30,20,10,00,00,00,00,00,00,00,00,00,00
'NW-SE Resize
DATA 6,6
DATA FF,FF,FF,80,FF,81,FF,83,FF,81,FF,80,77,90,27,B8
DATA 07,FC,07,FE,07,FF,07,FE,07,FC,FF,FF,FF,FF,FF,FF
DATA 00,00,00,7F,00,42,00,44,00,42,00,51,88,68,58,44
DATA 28,02,08,01,88,00,08,01,F8,03,00,00,00,00,00,00
'NE-SW Resize
DATA 6,6
DATA FF,FF,07,FC,07,FE,07,FF,07,FE,07,FC,27,B8,77,90
DATA FF,80,FF,81,FF,83,FF,81,FF,80,FF,FF,FF,FF,FF,FF
DATA 00,00,F8,03,08,01,88,00,08,01,28,02,58,44,88,68
DATA 00,51,00,42,00,44,00,42,00,7F,00,00,00,00,00,00
'Link Select
DATA 5,0
DATA FF,FB,FF,F1,FF,F1,FF,F1,FF,F1,BF,F0,0F,30,07,10
DATA 07,80,07,C0,07,C0,0F,E0,0F,E0,1F,F0,1F,F0,3F,F8
DATA 00,04,00,0A,00,0A,00,0A,00,0A,40,0B,B0,CA,A8,AA
DATA 28,58,08,28,08,20,10,10,10,10,20,08,20,08,C0,07
'Pointer Move
DATA 0,0
DATA FF,3F,FF,1F,FF,0F,FF,07,FF,03,FF,01,EF,00,47,00
DATA 03,00,01,00,00,00,00,10,00,30,01,F8,03,F8,47,FC
DATA 00,C0,00,A0,00,90,00,88,00,84,00,82,10,81,28,80
DATA 44,80,EE,80,6D,91,00,AA,6D,C9,AE,04,44,04,28,03
'Pointer + up arrow
DATA 0,0
DATA FF,3F,FF,1F,FF,0F,FF,07,FF,03,FB,01,F1,00,60,00
DATA 31,00,11,00,F1,01,F1,10,F1,30,71,F8,71,F8,7F,FC
DATA 00,C0,00,A0,00,90,00,88,00,84,04,82,0E,81,9B,80
DATA 4A,80,EA,83,0A,92,0A,A9,0A,C9,8A,04,8E,04,80,03
'Pointer + down arrow
DATA 0,0
DATA FF,3F,FF,1F,FF,0F,FF,07,FF,03,FF,01,F1,00,71,00
DATA 31,00,11,00,F1,01,F1,10,E0,30,71,F8,7B,F8,7F,FC
DATA 00,C0,00,A0,00,90,00,88,00,84,00,82,0E,81,8A,80
DATA 4A,80,EA,83,0A,92,0A,A9,1B,C9,8E,04,84,04,80,03
'I-Beam
DATA 3,5
DATA FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF
DATA FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF,FF
DATA 00,6C,00,10,00,10,00,10,00,10,00,10,00,10,00,10
DATA 00,10,00,10,00,6C,00,00,00,00,00,00,00,00,00,00

SCREEN 12
DefaultCursor% = 0
MouseSetPointer DefaultCursor%
MouseShow

COLOR 2
LINE (10, 10)-(35, 25), , B

CALL mbox(10, 10, 35, 25)

PRINT "Cows I Win"

END

FUNCTION GetPath$
tmp% = 1
DEF SEG = VARSEG(tmp%)
DO
  i% = i% + 1
  a% = PEEK(5861 + i%)  '5861
  IF a% = 0 THEN EXIT DO
  p$ = p$ + CHR$(a%)
LOOP UNTIL i% > 255
d% = 1
IF INSTR(p$, ":\") = 0 THEN
  FOR a& = 1 TO 65534
    IF PEEK(a&) = ASC(":") AND PEEK(a& + 1) = ASC("\") THEN 'Looking for :\
      p$ = ""                                         'Empty Path string
      B% = -1
      WHILE PEEK(a& + B%) > 0                            'Reading path letter
        p$ = p$ + CHR$(PEEK(a& + B%))              'by letter
        B% = B% + 1
      WEND
      GetPath = p$                                    'Prepare to exit loop
      EXIT FOR
    END IF
  NEXT
END IF
IF INSTR(p$, ".") > 0 THEN
  DO
    f% = INSTR(d%, p$, "\")
    IF f% = 0 THEN EXIT DO
    d% = f% + 1
  LOOP
  p$ = LEFT$(p$, d% - 2)
END IF
GetPath$ = p$
END FUNCTION

SUB mbox (a%, B%, c%, d%)
DO UNTIL v% = 1

  MouseStatus lb%, rb%, x%, y%
  'LOCATE 5, 1
  'PRINT x%, y%, lb%
  IF lb% = -1 AND x% > a% AND x% < c% AND y% > B% AND y% < d% THEN LET v% = 1
LOOP
END SUB

SUB MouseDriver (ax%, bx%, cx%, dx%)
  DEF SEG = VARSEG(Mouse$)
  Mouse% = SADD(Mouse$)
  CALL Absolute(ax%, bx%, cx%, dx%, Mouse%)
END SUB

SUB MouseHide
 ax% = 2
 MouseDriver ax%, 0, 0, 0
END SUB

FUNCTION MouseInit%
  ax% = 0
  MouseDriver ax%, 0, 0, 0
  MouseInit% = ax%
END FUNCTION

SUB MousePut (x%, y%)
  ax% = 4
  cx% = x%
  dx% = y%
  MouseDriver ax%, 0, cx%, dx%
END SUB

SUB MouseRange (X1%, Y1%, X2%, Y2%)
  ax% = 7
  cx% = X1%
  dx% = X2%
MouseDriver ax%, 0, cx%, dx%
  ax% = 8
  cx% = Y1%
  dx% = Y2%
  MouseDriver ax%, 0, cx%, dx%
END SUB

SUB MouseSetPointer (i%)
ax% = 9
bx% = Cursor(i%).HotSpotX
cx% = Cursor(i%).HotSpotY
Temp = Cursor(i%).Image
dx% = VARPTR(Temp)
MouseDriver ax%, bx%, cx%, dx%
END SUB

SUB MouseShow
  ax% = 1
  MouseDriver ax%, 0, 0, 0
END SUB

SUB MouseStatus (lb%, rb%, xMouse%, yMouse%)
  ax% = 3
  MouseDriver ax%, bx%, cx%, dx%
  lb% = ((bx% AND 1) <> 0)
  rb% = ((bx% AND 2) <> 0)
  'If screen mode is 7 then divide cx% by 2
  'IF cx% <> 0 THEN cx% = cx% / 2
  'If screen mode is 0 then divide cx% and dx% by 8
  'cx% = cx% / 2
  xMouse% = cx%
  yMouse% = dx%
END SUB

SUB WaitLetGo
DO
  MouseStatus lb%, rb%, x%, y%
LOOP WHILE lb% OR rb%
END SUB

