'---------------------------------------------------------------------------
' MODDED FOR USE WITH FISHV3A
' DMAPlay 6.0 Final Build 12-19-2000
'     - a versatile DMA-based sound (.WAV, .VOC, and .RAW) file player
'     for QBasic, QB45, PDS, and VBDOS with realtime downsampling.
'     by Mike Huff (v1), Martin Rampersad (v2), & Toshi Horie (v3-6)
'     Available at http://www.ocf.berkeley.edu/~horie/project.html
'           ------------- programming notes ----------------
' Thanks:     * Ethan Brodsky, whose help made DMAPLAY4+ possible.
'             * Angelo Mottola for his support and testing on the SB16.
'             * Michael Sorensen for his brilliant ideas and feedback.
' Features:   * 2-channel sound mixing (echos possible).
'             * .WAV and .VOC file support.
'             * simplified calling scheme:  PlayWave Filename$
'             * bugfix: All files finish playing their tune.
'             * SB 2.0 to SB AWE64 background playing using DMA.
'             * smaller source code size (as requested)
' Future Plans* complete 8 channel mixer routine
'             * EMS sound buffer swapping support
'             * interrupt and autoinit mode support (thanks to Michael)
' Legal:      * Toshihiro Horie will not be liable for any damages
'               resulting from the use or misuse of this program.
'---------------------------------------------------------------------------

TYPE wSoundType
	Stereo AS INTEGER
	Freq AS LONG
	StartPos AS LONG
	Length AS LONG
	playtime AS DOUBLE
	sixteenbit AS INTEGER
END TYPE

TYPE WaveHeaderType
		RiffID           AS STRING * 4 'should be 'RIFF'
		RiffLength       AS LONG
		'rept. chunk id and size then chunk data
		WavID            AS STRING * 4 'should be 'WAVE'
		FmtID            AS STRING * 4
		FmtLength        AS LONG
		wavformattag     AS INTEGER ' word - format category: 0x0001=PCM
		channels         AS INTEGER ' word - number of Channels 1=mono 2=stereo
		SamplesPerSec    AS LONG    'dword - sampling rate e.g. 44100Hz
		avgBytesPerSec   AS LONG    'dword - to estimate buffer size
		blockalign       AS INTEGER ' word - buffer size must be int. multiple of this
		FmtSpecific      AS INTEGER ' word
END TYPE

TYPE VocHeaderType
   CreativeID AS STRING * 20      'should be "Creative Voice File"+chr$(&H1A)
   FirstDataChunkOfs AS INTEGER   'usually &h1A (Intel format)
   Version AS INTEGER             'version number (Intel format)
   cVersion AS INTEGER            'one's complement of ver # + &h1234
END TYPE

TYPE VocOldDataInfoType  'cType=01
   SRbyte AS STRING * 1
   Compression AS STRING * 1
END TYPE

TYPE VocExtDataInfoType 'cType=08
   TC AS INTEGER        'Time constant
   pack AS STRING * 1   'pack type
   Stereo AS STRING * 1 '0=mono, 1=stereo
END TYPE

TYPE VocNewDataInfoType   'cType=09
   SR AS INTEGER          'sample rate
   SR2 AS INTEGER         'usually 0
   bits AS STRING * 1     '8 or 16-bit
   channels AS STRING * 1 '1=mono 2=stereo
   unknown AS STRING * 1  'usually =4
   reserved AS STRING * 5 'should be =0
END TYPE

' function declarations..............................................
DECLARE SUB Convert2FAST (Bseg%, Boff%, L%)
DECLARE SUB Convert2 (Bseg%, Boff%, L%)
DECLARE FUNCTION GetWaveInfo% (Filename$)
DECLARE SUB PlayWave (Filename$)
DECLARE SUB Play2Waves (File1$, File2$)
DECLARE SUB Convert4 (Bseg%, Boff%, L%)
DECLARE SUB Convert5 (Bseg%, Boff%, L%)
DECLARE SUB Convert6 (Bseg%, Boff&, L%)
DECLARE SUB Convert7 (Bseg%, Boff&, L%)
DECLARE SUB InitMixer8bit ()
DECLARE SUB InitConvert2FAST ()
DECLARE SUB ConvertStereo (Freq&, Bseg%, Boff%, L%)
DECLARE SUB Mix2Buffers (Bseg%, Boff&, Bseg2%, Boff2&, L%, sixteenbit%)
DECLARE FUNCTION int2ULong& (signedint%)
DECLARE FUNCTION Ulong2int% (Ulong&)
DECLARE FUNCTION DMAStatus% ()
DECLARE FUNCTION DMADone% ()
DECLARE FUNCTION ResetDSP% ()
DECLARE FUNCTION ReadDSP% ()
DECLARE SUB SetStereo (OnOff%)
DECLARE SUB WriteDSP (byte%)
DECLARE SUB VocVolume (Right%, Left%, Getvol%)
DECLARE SUB MasterVolume (Right%, Left%, Getvol%)
DECLARE FUNCTION ReadDAC% () : DECLARE SUB WriteDAC (byte%)
DECLARE SUB SpeakerState (OnOff%) : DECLARE SUB DMAState (StopGo%)
DECLARE SUB DMAPlay (Segment&, offset&, Length&, Freq&, Stereo%)
DECLARE SUB DMAPlay16 (Segment&, offset&, L&, Freq&, Stereo%, sixteenbit%)
DECLARE SUB GetBLASTER () : DECLARE FUNCTION DSPVersion! ()
'$DYNAMIC:  'needed for compilation in QB45

' global variables..............................................
COMMON SHARED baseport%, LenPort%, dma%, dma16%, cardversion%
Playerversion$ = "DMAPlay 6.0f"
DIM SHARED wSound AS wSoundType
DIM SHARED MixRoutine%(29)
InitMixer8bit
InitConvert2FAST

' main program...................................................
'PRINT Playerversion$
'PRINT "By Mike Huff (SB, SBPro) and Toshi Horie (SB16, SBPro realtime conv/mixing)"
'PRINT "Modified By Martin Rampersad (To play entire file instead of first 32k)"
'PRINT "Questions, comments, etc. can be sent to horie a_t ocf.berkeley.edu."
baseport% = &H220: irq% = 5: dma% = 1: 'default
GetBLASTER ' Parses BLASTER environment
'PRINT STRING$(80, 196)
SpeakerState 1


MasterVolume 12, 12, 0
VocVolume 12, 12, 0

'If you don't hear anything, maybe the volume is
'too low.  To find out, change the statements above to
'MasterVolume 15, 15, 0
'VocVolume 15, 15, 0

'blocklen MUST be divisible by 4 for stereo files
'make blocklen smaller if you get 'Subscript out of range' or
'other Out of Memory errors.
CONST blocklen = 32760

'create 32K buffer
DIM SHARED WavBuffer(0) AS STRING * blocklen

OPEN "wav.isf" FOR INPUT AS #4
INPUT #4, datax$
CLOSE #4

'sample routines - change this to play your own files
PlayWave datax$
CHAIN "fishv3a.bas"
END
PlayWave "C:\SBDISK\SND\YOUWANNA.VOC"
PlayWave "C:\SBDISK\SND\BIRD1-1.VOC"
FOR t = 1 TO 4
PlayWave "C:\QB45\WHOOSH1.WAV"
NEXT t
PlayWave "C:\SBDISK\SND\TOILET.VOC"
PlayWave "C:\QB45\ARROWS.WAV"
PlayWave "C:\PROGRAM\SB09\EXAMPLES\TEST1.VOC"
PlayWave "C:\SOUND\CD_AUDIO\STEREO.WAV"
Play2Waves "C:\SOUND\CD_AUDIO\STEREO.WAV", "C:\SOUND\CD_AUDIO\S4416.WAV"

DMAState 0: 'stop sound
quit% = ResetDSP%
CLOSE
END
' end main program.............................................

SUB Convert2 (Bseg%, Boff%, L%)
'converts 44KHz stereo to 22Khz stereo
'optimized conversion routine playing every other sample.
'used for 22Khz or higher stereo waves on SBPro
'no more long integer calculations
DEF SEG = Bseg%
FOR i = 0 TO L% - 1 STEP 8
	'LEFT CHANNEL
	Addy = i + Boff%
	hibyte% = PEEK(Addy + 1)    'i+1
	POKE Boff% + i \ 4, hibyte% XOR &H80

	'RIGHT CHANNEL
	hibyte% = PEEK(Addy + 3)    'i+4
	POKE Boff& + i \ 4 + 1, hibyte% XOR &H80
NEXT
END SUB

SUB Convert2FAST (Bseg%, Boff%, L%)
'There seems to be a bug in the convert2fast routine.
'It causes an illegal operation error in a Win98 DOS box.
'I will try to fix this ASAP. (It worked fine under Win95 though)
'
'if you get ERROR: Subprogram not defined here, you need to load
'QuickBasic using QB/LQB

'blazingly fast 16-bit to 8-bit conversion routine
'by Angelo Mottola.  Wow, it's 40x faster than the QB4.5 version.
' The "L" parameter does not need to be decreased!
DEF SEG = VARSEG(AsM$)
CALL ABSOLUTE(BYVAL Bseg%, BYVAL Boff%, BYVAL L%, SADD(AsM$))
DEF SEG
' End of assembly call,
' now the array is filled with the converted values!
END SUB

SUB Convert3 (Bseg&, Boff&, L&)
'converts 16-bit 44Khz stereo to 8-bit 44Khz mono for SBPro
'not working yet!
FOR i = 0 TO L& - 1 STEP 4
	Addr = i + Boff&
	'Left=Left>>2
	Leftlo% = PEEK(Addr) \ 2
	Lefthi% = PEEK(Addr + 1) \ 2
	'Right=Right>>2
	Rightlo% = PEEK(Addr + 2) \ 2
	Righthi% = PEEK(Addr + 3) \ 2
	mix& = Lefthi% * 256 + Leftlo%
	mix& = mix& + Righthi% * 256 + Rightlo%
	mixhi% = (mix& AND &HFF00) \ &H100
	mixlo% = (mix& AND &HFF)
	POKE Boff& + i \ 4, mixlo%
	POKE Boff& + i \ 4 + 1, mixhi%
NEXT i
END SUB

SUB Convert4 (Bseg%, Boff%, L%)
'convert 16 bit mono to 8 bit mono
DEF SEG = Bseg%
FOR i = 0 TO L% - 1 STEP 2
	Addr = i + Boff%
	hibyte% = PEEK(Addr + 1)    'i+1
	POKE Boff& + i \ 2, hibyte% + &H80
NEXT

END SUB

SUB Convert5 (Bseg%, Boff%, L%)
'takes 0L 0R 1L 1R 2L 2R 3L 3R 4L 4R...
'   to 0L 0R 2L 2R 4L 4R...
DEF SEG = Bseg%
FOR i = 4 TO L% - 1 STEP 4
	vleft = PEEK(i)
	vright = PEEK(i + 1)
	POKE i \ 2, vleft
	POKE i \ 2 + 1, vright
NEXT i
END SUB

SUB Convert6 (Bseg%, Boff&, L%)
'finally a 44Khz 16bit stereo to 11Khz 8bit mono mixer for SB2.0/1.0
DEF SEG = Bseg%
FOR i = 0 TO L% - 1 STEP 16
	'LEFT CHANNEL
	Addy = i + Boff&
	hibyteL% = PEEK(Addy + 1)    'i+1
	hibyteR% = PEEK(Addy + 3)    'i+4
	v = ((hibyteR% XOR &H80) + (hibyteL% XOR &H80)) \ 2
	POKE Boff% + i \ 16, v
NEXT
END SUB

SUB Convert7 (Bseg%, Boff&, L%)
'finally a 44Khz 8bit stereo to 11Khz 8bit mono mixer for SB2.0/1.0
DEF SEG = Bseg%
FOR i = 0 TO L% - 1 STEP 16
	Addy = i + Boff&
	byteL% = PEEK(Addy)
	byteR% = PEEK(Addy + 1)
	v = (byteR% + byteL%) \ 2
	POKE Boff% + i \ 16, v
NEXT
END SUB

SUB ConvertStereo (Freq&, Bseg%, Boff%, L%)
IF Freq& > 22050 THEN
	Convert2 Bseg%, Boff%, L%
ELSE
	'shouldn't need it unless using sb1.x-2.x
	'Convert2 Bseg%, Boff&, L%
END IF
END SUB

REM $STATIC
FUNCTION DMADone%
'DMA16% passed implicitly
countlo% = INP(LenPort%)
counthi% = INP(LenPort%)
IF counthi% = 255 AND countlo% = 255 THEN
		IF dma16% THEN
				ack16% = INP(baseport% + &HF) 'ack to SB
				'OUT &HA0, &H20 'acknowledge SB interrupt 8-15
				'OUT &H20, &H20 'acknowledge SB interrupt 1-15
		ELSE
				ack% = INP(baseport% + &HE)
				'OUT &H20, &H20 'acknowledge SB interrupt 1-15
		END IF
		DMADone% = -1
END IF
END FUNCTION

REM $DYNAMIC
SUB DMAPlay (Segment&, offset&, Length&, Freq&, Stereo%)
' Transfers and plays the contents of the buffer.
'IF Freq& < 4000 THEN PRINT "Freq too low!": END
'LOCATE 21, 1
'SELECT CASE cardversion%
'  CASE 1:
'    IF Freq& > 11111 THEN PRINT "SB1.0 Freq"; Freq&; "too high!": END
'   CASE 2:
'    IF Freq& > 15151 THEN PRINT "SB2.0 Freq"; Freq&; " too high!": END
'   CASE IS > 2:
'    IF Freq& > 45454 THEN PRINT "SBPro Freq"; Freq&; " too high!": END
'END SELECT
Length& = Length& - 1
page% = 0
Addr& = Segment& * 16 + offset&

'StartPage& = Addr& \ &H10000
'EndPage& = (Addr& + L&) \ &H10000
'IF StartPage& <> EndPage& THEN PRINT "Unable to allocate memory for DMA transfer.": STOP

SELECT CASE dma%
	CASE 0
	   PgPort% = &H87
	   AddPort% = &H0
	   LenPort% = &H1
	   ModeReg% = &H48
	CASE 1
	   PgPort% = &H83
	   AddPort% = &H2
	   LenPort% = &H3
	   ModeReg% = &H49
	CASE 2
	   PgPort% = &H81
	   AddPort% = &H4
	   LenPort% = &H5
	   ModeReg% = &H4A
	CASE 3
	   PgPort% = &H82
	   AddPort% = &H6
	   LenPort% = &H7
	   ModeReg% = &H4B
	CASE ELSE
	   PRINT "8-bit DMA channels 0-3 only!": END
	   EXIT SUB
END SELECT
Lengthlo% = Length& AND &HFF
Lengthhi% = (Length& AND &HFF00&) \ &H100
IF Stereo% AND cardversion% = 3 THEN SetStereo 1
OUT &HA, &H4 + dma%: 'DMA channel to use (DRQ#)
OUT &HC, &H0
OUT &HB, ModeReg%
OUT AddPort%, Addr& AND &HFF:  'buffer address of sound data low byte
OUT AddPort%, (Addr& AND &HFF00&) \ &H100: 'high byte
IF (Addr& AND 65536) THEN page% = page% + 1: '64K pages for 8-bit DMA
IF (Addr& AND 131072) THEN page% = page% + 2
IF (Addr& AND 262144) THEN page% = page% + 4
IF (Addr& AND 524288) THEN page% = page% + 8
OUT PgPort%, page%: 'output page of phys. addr of sample block
OUT LenPort%, Lengthlo%: 'size of block to DMA controller -Low
OUT LenPort%, Lengthhi%: 'high byte
OUT &HA, dma%: 'release DMA channel

'LOCATE 21, 1: PRINT "seg:"; DEC2HEX$(Segment&),
'PRINT "offset:"; DEC2HEX$(Offset&), "addr:"; DEC2HEX$(addr&)


TimeConst% = 256 - 1000000 \ Freq&

IF Freq& < 22728 THEN
   WriteDSP &H40
   WriteDSP TimeConst%
   WriteDSP &H14:                      '8 bit output over DMA
   WriteDSP (Length& AND &HFF)
   WriteDSP ((Length& AND &HFFFF&) \ &H100)
ELSE 'SBPro (DSP version 3.x) can play 8-bit mono/stereo wave files
   IF cardversion% > 2 THEN
	  'high speed 8 bit output up to 44kHz mono or 22Khz stereo
	  WriteDSP &H40:  'output sampling rate const
	  WriteDSP TimeConst%
	  WriteDSP &H48
	  WriteDSP Lengthlo%
	  WriteDSP Lengthhi%
	  WriteDSP &H91
   ELSE
	  PRINT "Current Freq&="; Freq&
	  PRINT "You need a Sound Blaster Pro to play at 8 bit high speed.": END
   END IF
END IF
END SUB

SUB DMAPlay16 (Segment&, offset&, L&, Freq&, Stereo%, sixteenbit%)
' Transfers and plays the contents of the buffer.
' Try only on an SoundBlaster 16 !!
' 1 page=128K in 16 bit mode
' DMA16% (16-bit DMA channel) passed implicitly

IF cardversion% < 4 THEN PRINT "You need an SB16 for this mode!": END
L& = L& - 1: page% = 0
Addr& = Segment& * 16 + offset&

'StartPage& = Addr& \ &H10000
'EndPage& = (Addr& + L&) \ &H10000
'IF StartPage& <> EndPage& THEN PRINT "Unable to allocate memory for DMA transfer.": STOP


IF sixteenbit% THEN
	SELECT CASE dma16%
	CASE 4
	   PgPort% = &H0
	   AddPort% = &HC0
	   LenPort% = &HC2
	   ModeReg% = &H48: '58h for autoinit/48h for not
	CASE 5
	   PgPort% = &H8B
	   AddPort% = &HC4
	   LenPort% = &HC6
	   ModeReg% = &H49
	CASE 6
	   PgPort% = &H89
	   AddPort% = &HC8
	   LenPort% = &HCA
	   ModeReg% = &H4A
	CASE 7
	   PgPort% = &H8A 'ok
	   AddPort% = &HCC 'ok
	   LenPort% = &HCE 'ok
	   ModeReg% = &H4B 'ok
	CASE ELSE
	   PRINT "16 bit DMA channels 4-7 only!"
	   EXIT SUB
	END SELECT
	page% = (Addr& \ 131072) * 2
	Offset2& = (Addr& - (page% * 65536)) \ 2
	Lengthlo% = ((L& \ 2) AND &HFF): 'number of words-1
	Lengthhi% = (((L& \ 2) AND &HFF00&) \ &H100)

	OUT &HD8, 0: 'clear flip flop
	OUT &HD6, ModeReg%: 'write mode reg
	OUT AddPort%, (Offset2& AND &HFF):            'Buffer base offset lo
	OUT AddPort%, (Offset2& AND &HFF00&) \ &H100: 'Buffer base offset hi
	OUT PgPort%, page%:                          'output page of phys. addr of sample block
	OUT LenPort%, Lengthlo%:                     'DMA count = length of buffer
	OUT LenPort%, Lengthhi%:                     'DMA count high byte
	OUT &HD4, dma16% - 4: 'write single mask (select Channel16)

ELSE
	SELECT CASE dma%
	CASE 0
	   PgPort% = &H87
	   AddPort% = &H0
	   LenPort% = &H1
	   ModeReg% = &H48
	CASE 1
	   PgPort% = &H83
	   AddPort% = &H2
	   LenPort% = &H3
	   ModeReg% = &H49
	CASE 2
	   PgPort% = &H81
	   AddPort% = &H4
	   LenPort% = &H5
	   ModeReg% = &H4A
	CASE 3
	   PgPort% = &H82
	   AddPort% = &H6
	   LenPort% = &H7
	   ModeReg% = &H4B
	CASE ELSE
	   PRINT "8-bit DMA channels 0-3 only!": END
	   EXIT SUB
	END SELECT
	Lengthlo% = L& AND &HFF
	Lengthhi% = (L& AND &HFF00&) \ &H100
	OUT &HA, &H4 + dma%: 'DMA channel to use (DRQ#)
	OUT &HC, &H0
	OUT &HB, ModeReg%
	OUT AddPort%, Addr& AND &HFF:  'buffer address of sound data low byte
	OUT AddPort%, (Addr& AND &HFF00&) \ &H100: 'high byte
	page% = (Addr& \ 65536) '64K pages for 8bit output
	OUT PgPort%, page%: 'output page of phys. addr of sample block
	OUT LenPort%, Lengthlo%: 'size of block to DMA controller -Low
	OUT LenPort%, Lengthhi%: 'high byte
	OUT &HA, dma%: 'release DMA channel
END IF



FreqHi% = (Freq& AND &HFF00&) \ &H100
FreqLo% = Freq& AND &HFF
WriteDSP &H41: 'set output sampling rate
WriteDSP FreqHi%
WriteDSP FreqLo%
IF sixteenbit% THEN
	WriteDSP &HB0:  '16 bit DAC, single cycle, FIFO off
ELSE
	WriteDSP &HC0: '8 bit DAC, single cycle, FIFO off
END IF
IF sixteenbit% THEN
	IF Stereo% THEN 'subtract 10h for unsigned
		WriteDSP &H30: '30h=Mode byte for 16 bit signed stereo
	ELSE
		WriteDSP &H10: '10h=Mode byte for 16 bit signed mono
	END IF
ELSE
	IF Stereo% THEN 'subtract 10h for unsigned
		WriteDSP &H20: '20h=Mode byte for 8 bit unsigned stereo
	ELSE
		WriteDSP &H0:  '0h=Mode byte for 8 bit unsigned mono
	END IF
END IF
WriteDSP Lengthlo%
WriteDSP Lengthhi%
END SUB

SUB DMAState (StopGo%)
' Stops or continues DMA play.
IF StopGo% THEN WriteDSP &HD4 ELSE WriteDSP &HD0
END SUB

FUNCTION DSPVersion!
' Gets the DSP version.
WriteDSP &HE1
Temp% = ReadDSP%
temp2% = ReadDSP%
IF temp2% < 10 THEN
	DSPVersion! = VAL(STR$(Temp%) + ".0" + STR$(temp2%))
ELSE
	DSPVersion! = VAL(STR$(Temp%) + "." + STR$(temp2%))
END IF

'MODEL          VERSION
'SB 1.0         1.?? (1.05???, err=2.00)
'SB 1.5         1.?? (1.05???)
'SB 2.0         2.xx (2.01)
'SB Pro         3.00 (???)
'SB Pro 2       3.01+ (3.01, 3.02)
'SB 16          4.0x (4.04, 4.05)
'SB 16 SCSI-2   4.11 (4.11)
'SB AWE 32      4.12+ (4.12)
END FUNCTION

SUB GetBLASTER
' This subroutine parses the BLASTER environment string
' and returns the sound card settings
' implicitly using COMMON variables Baseport%, DMA%, DMA16%

blaster$ = ENVIRON$("BLASTER")
IF LEN(blaster$) = 0 THEN
	PRINT "BLASTER environment variable not set."
	INPUT "Would you like to try the defaults? <y/n>"; ck$
	IF ck$ = "Y" OR ck$ = "y" THEN
		blaster$ = "A220 I5 D1 H5"
	ELSE
		PRINT "Goodbye."
		END
	END IF
ELSE
	FOR index% = 1 TO LEN(blaster$)
		SELECT CASE MID$(UCASE$(blaster$), index%, 1)
		  CASE "A"
			baseport% = VAL("&H" + MID$(blaster$, index% + 1, 3))
		  CASE "I"
			irq% = VAL(MID$(blaster$, index% + 1, 1))
		  CASE "D"
			dma% = VAL(MID$(blaster$, index% + 1, 1))
		  CASE "H"
			dma16% = VAL(MID$(blaster$, index% + 1, 1))
		  CASE ELSE
		END SELECT
	NEXT
END IF

'PRINT hex$(baseport%), irq%, dma%, dma16%

IF ResetDSP% = 0 THEN 'resets DSP (returns true if sucessful)
   PRINT "Sound card NOT found at " + HEX$(baseport%) + "H."
   PRINT "Either your card is not SB-compatible or it is set up wrong."
   END
END IF
'PRINT "Sound Card DSP version:"; DSPVersion!
cardversion% = INT(DSPVersion!)
END SUB

FUNCTION GetWaveInfo% (Filename$)
'PRE: Filename$ of sound file to parse
'POST: wSound fields set, file handle returned
'NOTE: only one valid sound block can be put in wSound.
'VARS: blockalign, chan

DIM Wave AS WaveHeaderType
DIM Voc AS VocHeaderType
DIM VocNew AS VocNewDataInfoType
DIM VocOld AS VocOldDataInfoType
DIM VocExt AS VocExtDataInfoType
DIM ChunkID AS STRING * 4
DIM DataLength AS LONG

ff = FREEFILE
OPEN Filename$ FOR BINARY AS ff
IF LOF(ff) = 0 THEN
	PRINT "**"; Filename$; " doesn't exist.**"
	CLOSE : KILL Filename$: END
END IF

IF INSTR(UCASE$(Filename$), ".WAV") THEN
	GET #ff, 1, Wave: 'BASIC defines beginning of file as 1
	wSound.StartPos = 45
	IF UCASE$(Wave.RiffID) <> "RIFF" THEN PRINT "NOT a RIFF Format file.": END
	IF UCASE$(Wave.WavID) <> "WAVE" THEN PRINT "NOT a Microsoft WAVE file.": END
	IF Wave.wavformattag <> 1 THEN PRINT "Not in PCM (uncompressed) format.": END
	wSound.Freq = Wave.SamplesPerSec
	chan = Wave.channels
	SELECT CASE Wave.channels
		CASE 2
			wSound.Stereo% = 1
		CASE 1
			wSound.Stereo% = 0
		CASE ELSE
			wSound.Stereo = 0
	END SELECT
	'assume no weird sampling rate like 9bit/sec
	'PRINT "This should equal blockalign:"; (Wave.avgBytesPerSec / Freq&)
	IF blocklen MOD Wave.blockalign THEN PRINT "Internal error: make blocklen=32752": END
	IF Wave.FmtSpecific = 16 THEN wSound.sixteenbit = 1 ELSE wSound.sixteenbit = 0
	'PRINT "current offset"; SEEK(ff)
	nextchunkpos& = 21& + Wave.FmtLength
	firstchunkpos& = nextchunkpos&
	'PRINT "next chunk at offset:"; ooo&
   
	DO
		SEEK #ff, nextchunkpos&
		GET #ff, , ChunkID
		currentoffset& = SEEK(ff)
		GET #ff, , chunklength&
		'PRINT ChunkID, chunklength&
		nextchunkpos& = currentoffset& + chunklength& + 4
		SELECT CASE UCASE$(ChunkID)
			CASE "FACT"
				GET #1, , filesize&
				'PRINT "fact chunk reports filesize as"; filesize&
			CASE "DATA"
				DataLength = chunklength&
				wSound.Length = DataLength
				wSound.playtime = wSound.Length / wSound.Freq / Wave.blockalign
				blockalign = Wave.blockalign
				GOTO doneinfo
			CASE ELSE
				PRINT "unknown chunk "; ChunkID; "- skipped"
		END SELECT
	LOOP UNTIL EOF(ff)

		PRINT "DMAPLAY could not find any playable wave data in"; Filename$; "."
		PRINT "If you're sure there's playable stuff in there, press Y"
		PRINT "to force it to play the file.  You may hear some noise."
		PRINT "Do you still want to play the file <Y/N>"
		yorn$ = ""
		DO: yorn$ = INKEY$: LOOP WHILE yorn$ = ""
		IF INSTR(UCASE$(yorn$), "Y") THEN
			wSound.StartPos = SEEK(ff)
			wSound.Length = LOF(ff) - wSound.StartPos
			wSound.Freq = 22050
			'guess that big files are in 16-bit
			IF wSound.Length > 300000 THEN
				wSound.sixteenbit = 1
			ELSE
				wSound.sixteenbit = 0
			END IF
			wSound.Stereo = 0
			chan = 1
			blockalign = (2 ^ wSound.sixteenbit) * chan
			wSound.playtime = wSound.Length / wSound.Freq / (wSound.sixteenbit + 1)
		ELSE
			PRINT "Please contact horie a_t ocf.berkeley.edu "
			PRINT "if you want DMAPLAY to play your file correctly."
			END
		END IF
ELSEIF INSTR(UCASE$(Filename$), ".VOC") THEN

'VOCData Chunk has 3 fields-- type, size, and info
'The type field is 1 byte, size is 3, and the info field varies in length.
	GET #ff, 1, Voc
	VOCMagic$ = "Creative Voice File" + CHR$(&H1A)
	IF Voc.CreativeID <> VOCMagic$ THEN PRINT "Not a VOC file": END
	SEEK #ff, Voc.FirstDataChunkOfs + 1
	DO
		ctype$ = "*": GET #ff, , ctype$
		vchunkid% = ASC(ctype$)
		IF vchunkid% = 0 THEN EXIT DO
		size$ = SPACE$(3): GET #ff, , size$
		dlen& = ASC(MID$(size$, 1, 1)) + ASC(MID$(size$, 2, 1)) * 256& + ASC(MID$(size$, 3, 1)) * 65536
		infostart& = SEEK(ff)
		SELECT CASE vchunkid%
			CASE 0:
				EXIT DO
			CASE 1:
				'PRINT "* VOC Sound Data"
				wSound.sixteenbit = 0
				wSound.StartPos = SEEK(ff)
				GET #ff, , VocOld
				SRbyte = ASC(VocOld.SRbyte)
				IF extdataflag = -1 THEN
					' leave wSound.stereo alone
					blockalign = (2 ^ wSound.sixteenbit) * chan
				ELSE
					wSound.Stereo = 0
					chan = 1
					wSound.sixteenbit = 0
					wSound.Freq = CLNG(1000000 / (256 - SRbyte))
					blockalign = (2 ^ wSound.sixteenbit) * chan
				END IF
				extdataflag = 0
				wSound.Length = dlen& - 2
				SELECT CASE ASC(VocOld.Compression)
					CASE 0: 'PRINT "   8-bits (uncompressed)"
						wSound.playtime = wSound.Length / 1000000 * (256 - SRbyte)
					CASE 1: PRINT "   4-bits": END
					CASE 2: PRINT "   2.6-bits": END
					CASE 3: PRINT "   2 bits": END
					CASE IS > 3: PRINT "    Multi-DAC with "; ASC(VocOld.Compression) - 3; "channels": END
				END SELECT
				EXIT DO
			CASE 2:
				'PRINT "* Sound Continue"
				'Note that all sound continue blocks are skipped
				'though they may contain other sounds.
			CASE 4:
				'PRINT "* Marker"
				GET #1, , marker%
			CASE 5:
				'PRINT "* ASCII"
			CASE 8:
				PRINT "* EXTENDED"
				GET #1, , VocExt
				wSound.sixteenbit = 0
				wSound.Stereo = ASC(VocExt.Stereo)
				IF wSound.Stereo THEN chan = 2 ELSE chan = 1
				IF ASC(VocExt.pack) THEN
					PRINT "packed sound data (unsupported)": END
				END IF
				TC& = (VocExt.TC + 65536) MOD 65536
				IF wSound.Stereo THEN
					wSound.Freq = 128000000 / (65536 - TC&)
				ELSE
					wSound.Freq = 256000000 / (65536 - TC&)
				END IF
				extdataflag = -1
			CASE 9:
				'PRINT "* New VOC format"
				GET #ff, , VocNew
				wSound.StartPos = SEEK(ff)
				wSound.Freq = VocNew.SR
				chan = ASC(VocNew.channels)
				IF chan = 2 THEN wSound.Stereo = 1 ELSE wSound.Stereo = 0
				IF wSound.sixteenbit = 16 THEN
					wSound.sixteenbit = 1
				ELSE
					wSound.sixteenbit = 0
				END IF
				blockalign = (2 ^ wSound.sixteenbit) * chan
				wSound.Length = dlen& - 12
		END SELECT
		SEEK #ff, infostart& + dlen&: 'seek to next chunk
	LOOP UNTIL EOF(ff)
ELSE
	'assume a 8-bit mono .RAW sound file and play the whole file
	'change these parameters so it works on your sound files.
	wSound.Stereo = 0: chan = 1
	wSound.Freq = 22000
	wSound.StartPos = 1
	wSound.sixteenbit = 0
	wSound.Length = LOF(ff) - wSound.StartPos + 1
	blockalign = (2 ^ wSound.sixteenbit) * chan
	wSound.playtime = wSound.Length / blockalign / wSound.Freq
END IF

doneinfo:
'PRINT "Samples/sec:"; wSound.Freq
'PRINT "Channels:"; chan;
IF wSound.Stereo% = 1 THEN
	'PRINT "(Stereo)"
ELSE
	'PRINT "(mono)  "
END IF
'PRINT "Block Align:"; blockalign
'PRINT "Resolution:";
'IF wSound.sixteenbit THEN PRINT " 16 ";  ELSE PRINT " 8 ";
'PRINT "bits/sample"
'PRINT "Data Length:"; wSound.Length; "bytes"
pmin = INT(wSound.playtime / 60)
psec = INT(wSound.playtime) MOD 60
IF pmin > 0 THEN
	'PRINT USING "Play Length: ##:"; pmin;
	'PRINT USING "##"; psec
ELSE
	'PRINT USING "Play Length: ##.##s"; wSound.playtime
END IF

GetWaveInfo = ff
END FUNCTION

DEFSTR A
SUB InitConvert2FAST
AsM$ = ""
AsM$ = AsM$ + CHR$(&H1E)                           ' PUSH DS
AsM$ = AsM$ + CHR$(&H55)                           ' PUSH BP
AsM$ = AsM$ + CHR$(&H89) + CHR$(&HE5)              ' MOV BP,SP
AsM$ = AsM$ + CHR$(&H8B) + CHR$(&H46) + CHR$(&HC)  ' MOV AX,[BP+0C]
AsM$ = AsM$ + CHR$(&H8E) + CHR$(&HD8)              ' MOV DS,AX
AsM$ = AsM$ + CHR$(&HBB) + CHR$(&H0) + CHR$(&H0)   ' MOV BX,0000
AsM$ = AsM$ + CHR$(&H8B) + CHR$(&H76) + CHR$(&HA)  ' Startloop: MOV SI,[BP+0A]
AsM$ = AsM$ + CHR$(&H1) + CHR$(&HDE)               ' ADD SI,BX
AsM$ = AsM$ + CHR$(&H46)                           ' INC SI
AsM$ = AsM$ + CHR$(&H8A) + CHR$(&H4)               ' MOV AL,[SI]
AsM$ = AsM$ + CHR$(&H34) + CHR$(&H80)              ' XOR AL,80
AsM$ = AsM$ + CHR$(&H46)                           ' INC SI
AsM$ = AsM$ + CHR$(&H46)                           ' INC SI
AsM$ = AsM$ + CHR$(&H8A) + CHR$(&H24)              ' MOV AH,[SI]
AsM$ = AsM$ + CHR$(&H80) + CHR$(&HF4) + CHR$(&H80) ' XOR AH,80
AsM$ = AsM$ + CHR$(&H89) + CHR$(&HDF)              ' MOV DI,BX
AsM$ = AsM$ + CHR$(&HB1) + CHR$(&H2)               ' MOV CL,02
AsM$ = AsM$ + CHR$(&HD3) + CHR$(&HEF)              ' SHR DI,CL
AsM$ = AsM$ + CHR$(&H3) + CHR$(&H7E) + CHR$(&HA)   ' ADD DI,[BP+0A]
AsM$ = AsM$ + CHR$(&H89) + CHR$(&H5)               ' MOV [DI],AX
AsM$ = AsM$ + CHR$(&H83) + CHR$(&HC3) + CHR$(&H8)  ' ADD BX,+08
AsM$ = AsM$ + CHR$(&H3B) + CHR$(&H5E) + CHR$(&H8)  ' CMP BX,[BP+08]
AsM$ = AsM$ + CHR$(&H7C) + CHR$(&HDC)              ' JL Startloop
AsM$ = AsM$ + CHR$(&H5D)                           ' POP BP
AsM$ = AsM$ + CHR$(&H1F)                           ' POP DS
AsM$ = AsM$ + CHR$(&HCA) + CHR$(&H6) + CHR$(&H0)   ' RETF 0006

END SUB

DEFINT A-Z
SUB InitMixer8bit

'programmed by Skywise 01/25/98
'8 bit wave files only
'CALL Absolute(BYVAL Bseg%, BYVAL off1%, BYVAL Bseg2%, BYVAL off2%, BYVAL L%, VARPTR(MixRoutine%(0)))
'                [SP+10h]    [sp+0E]       [sp+0C]       [sp+0A]    [sp+08]      [sp+06]
'                           ASSEMBLY INSTRUCTION : my interpretation
A$ = "1E":                    'push   ds         :save BASIC's DS = DEF SEG
A$ = A$ + "55":               'push   bp         :save BASIC's BP
A$ = A$ + "89E5":             'mov    bp,sp      :bp=SP
A$ = A$ + "8B5608":           'mov    dx,[bp+08] :dx=L%
A$ = A$ + "BB0000":           'mov    bx,0000    :bx=0
A$ = A$ + "8CDF":             'mov    di,ds      :di=DS
						'LABEL 010C:
A$ = A$ + "8B460C":           'mov    ax,[bp+0C] :ax=Bseg2%
A$ = A$ + "8B760A":           'mov    si,[bp+0A] :si=off2%
A$ = A$ + "01DE":             'add    si,bx      :si=off2%+bx
A$ = A$ + "8ED8":             'mov    ds,ax      :DEF SEG=Bseg2%
A$ = A$ + "8A0C":             'mov    cl,[si]    :cl=Buffer2[off2%+c%]
A$ = A$ + "8EDF":             'mov    ds,di      :DEF SEG (to BASIC's codseg)
A$ = A$ + "8B4610":           'mov    ax,[bp+10] :ax=Bseg%
A$ = A$ + "8B760E":           'mov    si,[bp+0E] :si=off1%
A$ = A$ + "01DE":             'add    si,bx      :si=off1% + c%
A$ = A$ + "8ED8":             'mov    ds,ax      :DEF SEG=Bseg%
A$ = A$ + "8A2C":             'mov    ch,[si]    :ch=sample1=Buffer1[off1%]
A$ = A$ + "D0ED":             'shr    ch,1       :sample1=sample1 / 2
A$ = A$ + "D0E9":             'shr    cl,1       :sample2=sample2 / 2
A$ = A$ + "00CD":             'add    ch,cl      :sample1=sample1+sample2
A$ = A$ + "882C":             'mov    [si],ch    :array[off1%]=sample1
A$ = A$ + "8EDF":             'mov    ds,di      :DEF SEG (BASIC's codeseg)
A$ = A$ + "43":               'inc    bx         :c%=c%+1  ' c% is bx
A$ = A$ + "39D3":             'cmp    bx,dx      :is bx<dx?
A$ = A$ + "7CD7":       ' 0133: jl    010C       :LOOP WHILE bx<L%
A$ = A$ + "5D":               'pop    bp         :restore BASIC's bp
A$ = A$ + "1F":               'pop    ds         :restore BASIC's ds
A$ = A$ + "CA0600":           'retf   0006       :ret with 3 WORDs on stack

'-------create 8bit assembly mixer-------
rr% = VARPTR(MixRoutine%(0))
DEF SEG = VARSEG(MixRoutine%(0))
FOR ii% = 0 TO 57
	yy% = VAL("&h" + MID$(A$, ii% * 2 + 1, 2))
	POKE rr% + ii%, yy%
NEXT ii%
A$ = ""
END SUB

SUB InputSource (InputSrc%, GetSrc%)
OUT baseport% + 4, &HC
IF GetSrc% THEN
   InputSrc% = INP(baseport% + 5) AND 2 + INP(baseport% + 5) AND 4
ELSE
   OUT baseport% + 5, InputSrc% AND 7
END IF
END SUB

FUNCTION int2ULong& (signedint%)
IF signedint% < 0 THEN
		int2ULong& = CLNG(signedint% + 65536)
ELSE
		int2ULong& = CLNG(signedint%)
END IF
END FUNCTION

SUB MasterVolume (Right%, Left%, Getvol%)
OUT baseport% + 4, &H22
IF Getvol% THEN
   Left% = INP(baseport% + 5) \ 16
   Right% = INP(baseport% + 5) AND &HF
   EXIT SUB
ELSE
   OUT baseport% + 5, (Right% + Left% * 16) AND &HFF
END IF
END SUB

SUB Mix2Buffers (Bseg%, Boff&, Bseg2%, Boff2&, L%, sixteenbit%)
DEF SEG = Bseg2% 'ASSUMES Bseg2%=Bseg%
IF Boff& <> 0 THEN PRINT "oops in mix2buffers": END


IF sixteenbit% THEN '16 bit signed mixing
	'sounds almost as good in 8bit "cheat" mode on SBPro (clicks)
	'this cheat mode can be converted to asm with only a few byte
	'difference than the Mixer8bit code. change the inc bx to an add bx,2
	'and adjust the jl 0106 and initially mov bx,0001. -from Toshi
	FOR i = 0 TO L% STEP 2
		hibyte2% = PEEK(Boff2& + i + 1)
		hibyte1% = PEEK(i + 1)
		POKE i + 1, hibyte2% + hibyte1%: 'QB automatically casts to char
	NEXT
	'real 16 bit mixing == SLOW because BASIC does not have unsigned ints
	'FOR i = 0 TO L% STEP 2
	'    hibyte2% = PEEK(Boff2& + i + 1)
	'    hibyte1% = PEEK(i + 1)
	'    lobyte2% = PEEK(Boff2& + i)
	'    lobyte1% = PEEK(i)
	'    v1 = Ulong2int(hibyte1% * 256& + lobyte1%) \ 2
	'    v2 = Ulong2int(hibyte2% * 256& + lobyte2%) \ 2
	'    v = v1 + v2 AND &HFFFF
	'    POKE i + 1, v \ 256
	'    POKE i, v AND 255
	'NEXT
ELSE
	'8 bit unsigned mixing
	off1% = Ulong2int(Boff&)
	off2% = Ulong2int(Boff2&)

	DEF SEG = VARSEG(MixRoutine%(0))
	CALL ABSOLUTE(BYVAL Bseg%, BYVAL off1%, BYVAL Bseg2%, BYVAL off2%, BYVAL L%, VARPTR(MixRoutine%(0)))
	DEF SEG


	'QB version works fine too
	'FOR i = 0 TO L% STEP 2
	'    byte2a = PEEK(Boff2& + i)
	'    byte2b = PEEK(Boff2& + i + 1)
	'    byte1a = PEEK(i)
	'    byte1b = PEEK(i + 1)
	'    o1 = (byte1a + byte2a) \ 2 'For loud files, this sounds better
	'    o2 = (byte1b + byte2b) \ 2 'than adding samples then clipping.
	''    IF o1 AND 256 THEN o1 = 255 'clipping
	''    IF o2 AND 256 THEN o2 = 255 'clipping
	'    POKE i, o1
	'    POKE i + 1, o2
	'NEXT
END IF
END SUB

SUB Play2Waves (File1$, File2$)
'Mixes two files in realtime
'files must be of the same type, sampling frequency, etc.

LOCATE 8, 1: PRINT "Playing mixed " + File1$; " and "; File2$
filenum = GetWaveInfo(File1$)
StartPos% = wSound.StartPos
RLength& = wSound.Length&: 'RLength& is number of remaining bytes

Freq& = wSound.Freq
Freq2& = Freq& * 2
Stereo% = wSound.Stereo
sixteenbit% = wSound.sixteenbit

'compare two file types - must be the same type!
filenum2 = GetWaveInfo(File2$)
IF Stereo% <> wSound.Stereo THEN COLOR 14, 4: PRINT "*Incompatible file types*": END
IF Freq& <> wSound.Freq THEN COLOR 14, 4: PRINT "*Incompatible file types*": END
IF sixteenbit% <> wSound.sixteenbit THEN COLOR 14, 4: PRINT "*Incompatible file types*": END


css28 = cardversion% = 2 AND NOT sixteenbit% AND Stereo% 'on SB 2.0 8s->8mono
css2 = cardversion% = 2 AND sixteenbit% AND Stereo% 'on SB 2.0 16s->8mono
css = cardversion% = 3 AND sixteenbit% AND Stereo% '16s->8stereo on SBPro
cmm = cardversion% = 3 AND sixteenbit% AND NOT Stereo% '16mono->8mono
cskip = cardversion% <= 3 AND NOT sixteenbit% AND Stereo%: 'skip one
'cskip2 = cardversion% <= 2 AND NOT sixteenbit% AND NOT stereo%

REDIM WavBuffer(0 TO 1) AS STRING * blocklen
Bseg% = VARSEG(WavBuffer(0))
Boff% = VARPTR(WavBuffer(0))
Bseg& = int2ULong&(Bseg%)
Boff& = int2ULong&(Boff%)
Bseg2% = VARSEG(WavBuffer(1))
Boff2% = VARPTR(WavBuffer(1))
Bseg2& = int2ULong&(Bseg2%)
Boff2& = int2ULong&(Boff2%)
IF Bseg% <> Bseg2% THEN PRINT "Need more contiguous memory!": END
		firsttime = 1
		GET #filenum, StartPos%, WavBuffer(0) 'fill first buffer
		GET #filenum2, StartPos%, WavBuffer(1) 'fill first buffer
	   IF RLength& >= blocklen THEN
				L& = blocklen
				L% = blocklen
		ELSE
				L& = RLength&
				L% = CINT(RLength&)
	   END IF
	   Mix2Buffers Bseg%, Boff&, Bseg2%, Boff2&, L%, sixteenbit%
	   IF cskip OR cskip2 THEN Convert5 Bseg%, Boff%, L%: LOCATE 18, 55: PRINT "cskip"
	   IF css THEN Convert2FAST Bseg%, Boff%, L%: LOCATE 18, 44: PRINT "css Pro"
	   IF css2 THEN Convert6 Bseg%, Boff&, L%: LOCATE 18, 40: PRINT "css 2.0"
	   IF css28 THEN Convert7 Bseg%, Boff&, L%: LOCATE 18, 56: PRINT "css 28"
	   IF cmm THEN Convert4 Bseg%, Boff%, L%: LOCATE 18, 50: PRINT "cmm"
DO
		'............play block in the background.......................
		RLength& = RLength& - L& 'update remaining length
		'LOCATE 1, 13: COLOR 14
		IF sixteenbit% THEN
			SELECT CASE cardversion%
			CASE 4 'SB16, AWE32, AWE64
				PRINT "SB16 16bit mode"; Freq&; "Hz"
				DMAPlay16 Bseg&, Boff&, L&, Freq&, Stereo%, sixteenbit%
			CASE 3 'SBPro
				IF Stereo% THEN
				  PRINT "SBPro Realtime stereo"
				  DMAPlay Bseg&, Boff&, L& \ 4, Freq&, Stereo%
				ELSE 'mono 16 to 8 bit conversion
					PRINT "SBPro Realtime mono"
					DMAPlay Bseg&, Boff&, L& \ 2, Freq&, Stereo%
				END IF
			CASE 2 'SB 2.0
				IF Stereo% THEN
				  PRINT "SB2.0 RT Stereo16"
				  DMAPlay Bseg&, Boff&, L& \ 16, Freq& \ 4, 0
				ELSE
				  LOCATE 22, 1
				  PRINT "sb 2.0 44Khz 16bit stereo to 8bit mono not done."
				  END
				END IF
			CASE ELSE 'SB
					'COLOR 14, 4
					PRINT "SB Realtime conversions from stereo to mono not supported.": END
			END SELECT
		ELSE   '8 bit
				IF Stereo% THEN
					SELECT CASE cardversion%
						CASE 4
							LOCATE 1, 14: COLOR 14: PRINT "SB16 8bit stereo"; Freq&; "Hz"
							DMAPlay16 Bseg&, Boff&, L&, Freq&, Stereo%, sixteenbit%
						CASE 3
							IF cskip THEN
								DMAPlay Bseg&, Boff&, L& \ 2, Freq&, Stereo%
							ELSE
								DMAPlay Bseg&, Boff&, L&, Freq2&, Stereo%
							END IF
						CASE ELSE    'convert to sb2.0 8bit mono
						  PRINT "SBPro RT stereo8"
							DMAPlay Bseg&, Boff&, L& \ 2, Freq& \ 2, 0
					END SELECT
				ELSE 'mono 8-bit (no error checking)
					SELECT CASE cardversion%
						CASE 4
							LOCATE 1, 14: COLOR 14: PRINT "SB16 8bit mono"; Freq&; "Hz"
							DMAPlay16 Bseg&, Boff&, L&, Freq&, Stereo%, sixteenbit%
						CASE IS <= 2
							LOCATE 1, 14: COLOR 14: PRINT "SB mode"; Freq&; "Hz"
							DMAPlay Bseg&, Boff&, L& \ 2, Freq& \ 2, Stereo%
						CASE ELSE
							DMAPlay Bseg&, Boff&, L&, Freq&, Stereo%
					END SELECT
				END IF
		END IF
		'this works perfectly!
		IF RLength& = 0 THEN EXIT DO
		'..............................................................
				'fill buffer
				IF RLength& >= blocklen THEN
						L& = blocklen
						L% = blocklen
				ELSE
						L& = RLength&
						L% = blocklen
				END IF

				GET #filenum, , WavBuffer(0)
				GET #filenum2, , WavBuffer(1)
				Mix2Buffers Bseg%, Boff&, Bseg2%, Boff2&, L%, sixteenbit%
				IF css THEN Convert2FAST Bseg%, Boff%, L% 'should be convertstereo!!
				IF cmm THEN Convert4 Bseg%, Boff%, L%
				IF css2 THEN Convert6 Bseg%, Boff&, L%
				IF css28 THEN Convert7 Bseg%, Boff&, L%
				IF (cskip OR cskip2) THEN Convert5 Bseg%, Boff%, L%
		IF INKEY$ > "" THEN stopflag = 1
		DO UNTIL DMADone%
			   '
			   'now CPU is free to do graphics, etc.
			   '
			   '
		LOOP
		IF stopflag THEN EXIT DO:  'stop here so it doesn't freeze the computer
LOOP UNTIL EOF(filenum) OR EOF(filenum2)
'LOCATE 23, 1: PRINT "DMA transfer completed!";
DMAState 0: 'stop sound
quit% = ResetDSP%

END SUB

SUB PlayWave (Filename$)

'LOCATE 1, 65: PRINT "cycles free"
'LOCATE 8, 1: PRINT "Playing " + Filename$ + "           "

Freq& = 22000: 'default playback frequency
ff = GetWaveInfo(Filename$)

Freq& = wSound.Freq
Freq2& = Freq& * 2
Stereo% = wSound.Stereo
sixteenbit% = wSound.sixteenbit
StartPos% = wSound.StartPos

css28 = cardversion% = 2 AND NOT sixteenbit% AND Stereo% 'on SB 2.0 8s->8mono
css2 = cardversion% = 2 AND sixteenbit% AND Stereo% 'on SB 2.0 16s->8mono
css = cardversion% = 3 AND sixteenbit% AND Stereo% '16s->8stereo on SBPro
cmm = cardversion% = 3 AND sixteenbit% AND NOT Stereo% '16mono->8mono
cskip = cardversion% <= 3 AND NOT sixteenbit% AND Stereo%: 'skip one
'cskip2 = cardversion% <= 2 AND NOT sixteenbit% AND NOT stereo%

Bseg% = VARSEG(WavBuffer(0)): Boff% = VARPTR(WavBuffer(0))
Bseg& = int2ULong&(Bseg%): Boff& = int2ULong&(Boff%)

RLength& = wSound.Length&: 'RLength& is number of remaining bytes
IF RLength& > (LOF(ff) - StartPos% + 1) THEN
	RLength& = LOF(ff) - StartPos% + 1
	LOCATE 20, 1:  PRINT "warning: Truncated .WAV detected."
END IF

' fill buffer for the first time
GET #ff, StartPos%, WavBuffer(0) 'fill first buffer
IF RLength& > blocklen THEN
	L& = blocklen
	L% = blocklen
ELSE
	L& = RLength&
	L% = CINT(RLength&)
END IF
IF css THEN Convert2 Bseg%, Boff%, L%
'IF css THEN Convert2Fast Bseg%, Boff%, L%
IF cskip OR cskip2 THEN Convert5 Bseg%, Boff%, L%
IF css2 THEN Convert6 Bseg%, Boff&, L%
IF css28 THEN Convert7 Bseg%, Boff&, L%
IF cmm THEN Convert4 Bseg%, Boff%, L%
t1# = TIMER
DO
		RLength& = RLength& - L& 'update remaining length
		'LOCATE 20, 1: PRINT RLength&
		'............play block in the background.......................
		 'LOCATE 1, 13: COLOR 14
		IF sixteenbit% THEN
			SELECT CASE cardversion%
			CASE 4 'SB16, AWE32, AWE64?
				PRINT "SB16 16bit mode"
				DMAPlay16 Bseg&, Boff&, L&, Freq&, Stereo%, sixteenbit%
			CASE 3 'SBPro
				IF Stereo% THEN
				  PRINT "SBPro Realtime stereo"
				  DMAPlay Bseg&, Boff&, L& \ 4, Freq&, Stereo%
				ELSE 'mono 16 to 8 bit conversion
					PRINT "SBPro Realtime mono"
					DMAPlay Bseg&, Boff&, L& \ 2, Freq&, Stereo%
				END IF
			CASE 2 'SB 2.0
				IF Stereo% THEN
				  PRINT "SB2.0 RT Stereo16"
				  DMAPlay Bseg&, Boff&, L& \ 16, Freq& \ 4, 0
				ELSE
				  LOCATE 22, 1
				  PRINT "sb 2.0 44Khz 16bit stereo to 8bit mono not done."
				  END
				END IF
			CASE ELSE 'SB
					COLOR 14, 4
					PRINT "SB Realtime conversions from stereo to mono not supported.": END
			END SELECT
		ELSE   '8 bit
				IF Stereo% THEN
					SELECT CASE cardversion%
						CASE 4
							'LOCATE 1, 14: COLOR 14: PRINT "SB16 8bit stereo"; Freq&; "Hz"
							DMAPlay16 Bseg&, Boff&, L&, Freq&, Stereo%, sixteenbit%
						CASE 3
							IF cskip THEN
								DMAPlay Bseg&, Boff&, L& \ 2, Freq&, Stereo%
							ELSE
								DMAPlay Bseg&, Boff&, L&, Freq2&, Stereo%
							END IF
						CASE ELSE    'convert to sb2.0 8bit mono
						  PRINT "SBPro RT stereo8"
							DMAPlay Bseg&, Boff&, L& \ 2, Freq& \ 2, 0
					END SELECT
				ELSE 'mono 8-bit (no error checking)
					SELECT CASE cardversion%
						CASE 4
							'LOCATE 1, 14: COLOR 14: PRINT "SB16 8bit mono"; Freq&; "Hz"
							DMAPlay16 Bseg&, Boff&, L&, Freq&, Stereo%, sixteenbit%
						CASE IS <= 2
							LOCATE 1, 14: COLOR 14: PRINT "SB mode"; Freq&; "Hz"
							DMAPlay Bseg&, Boff&, L& \ 2, Freq& \ 2, Stereo%
						CASE ELSE
							DMAPlay Bseg&, Boff&, L&, Freq&, Stereo%
					END SELECT
				END IF
		END IF
		IF RLength& = 0 THEN EXIT DO
		'..............................................................
				'--- fill buffer ----
				IF RLength& > blocklen THEN
						L& = blocklen
						L% = blocklen
				ELSE
						L& = RLength&
						L% = blocklen
				END IF
				GET #1, , WavBuffer(0)
				'should be convertstereo!!
				IF css THEN Convert2 Bseg%, Boff%, L%
				'IF css THEN Convert2FAST Bseg%, Boff%, L%
				IF cmm THEN Convert4 Bseg%, Boff%, L%
				IF css2 THEN Convert6 Bseg%, Boff&, L%
				IF css28 THEN Convert7 Bseg%, Boff&, L%
				IF (cskip OR cskip2) THEN Convert5 Bseg%, Boff%, L%
	'Done filling buffer,,,,,,,,,,
		'LOCATE 1, 37: PRINT TIME$; "  "; 100 - INT(RLength& / wSound.Length& * 100); "% done  "; cycles%
		cycles% = 0
		DO UNTIL DMADone%
				'
				' now CPU is free to do graphics, etc.
				' put your animation update calls here
				'
				IF cycles% < 32767 THEN cycles% = cycles% + 1
				'Polling the Status/DMADone port too fast causes
				'jumpy sound - the print statement adds a delay :)
				'LOCATE 23, 1
				'COLOR 14
				'PRINT USING "###.##s"; (TIMER - t1#)
				LET tim# = TIMER
				DO UNTIL TIMER > tim# + .01
				'PRINT tim#
				LOOP
				IF INKEY$ > "" THEN stopflag = 1
		LOOP
		IF stopflag THEN EXIT DO:  'stop here so it doesn't freeze the computer
LOOP
CLOSE #ff

'can be taken out to provide more CPU time,
'if you are *not* playing any more files consequtively
DO UNTIL DMADone%:
	'COLOR 14, 0
	'LOCATE 23, 1
	'PRINT USING "###.##s"; (TIMER - t1#)
LOOP
'COLOR 7, 0
'LOCATE 22, 1: PRINT "DMA transfer completed!"
END SUB

FUNCTION ReadDAC%
' Reads a byte from the DAC.
WriteDSP &H20
ReadDAC% = ReadDSP%
END FUNCTION

FUNCTION ReadDSP%
WAIT (baseport% + &HE), &H80: 'wait for bit 7 on pollport
DO: DSPIn% = INP(baseport% + 10): LOOP UNTIL DSPIn% <> &HAA
ReadDSP% = DSPIn%
END FUNCTION

FUNCTION ResetDSP%
ct = 0: stat = 0: ready = &HAA
OUT baseport% + &H6, 1
DO
		OUT baseport% + &H6, 0
		stat = INP(baseport% + &HE)
		stat = INP(baseport% + &HA)
		IF stat = ready THEN EXIT DO
		ct = ct + 1
LOOP WHILE ct < 100 'wait about 100 ms
IF stat = ready THEN ResetDSP% = 1 ELSE ResetDSP% = 0
END FUNCTION

SUB SetStereo (OnOff%)
'only needed on SBPro
MixerReg% = baseport% + 4
MixerData% = baseport% + 5
		OUT MixerReg%, &HE
		IF OnOff% THEN
				OUT MixerData%, 2
		ELSE
				OUT MixerData%, 0
		END IF
END SUB

SUB SpeakerState (OnOff%)
' Turns speaker on or off 0=off, 1=on.
IF OnOff% THEN WriteDSP &HD1 ELSE WriteDSP &HD3
END SUB

FUNCTION Ulong2int% (Ulong&)
IF Ulong& > 32767 THEN
		Sint% = CINT(Ulong& - 65536)
ELSE
		Sint% = CINT(Ulong&)
END IF
Ulong2int% = Sint%
END FUNCTION

SUB VocVolume (Right%, Left%, Getvol%)
OUT baseport% + 4, &H4
IF Getvol% THEN
   Left% = INP(baseport% + 5) \ 16
   Right% = INP(baseport% + 5) AND &HF
   EXIT SUB
ELSE
   OUT baseport% + 5, (Right% + Left% * 16) AND &HFF
END IF
END SUB

SUB WriteDAC (byte%)
' Writes a byte to the DAC.
WriteDSP &H10
WriteDSP byte%
END SUB

SUB WriteDSP (byte%)
' Writes a byte to the DSP
DO: LOOP WHILE INP(baseport% + 12) AND &H80
OUT baseport% + 12, byte%
END SUB

SUB WriteMixer (cmd%, value%)
MixerReg% = baseport% + 4
MixerData% = baseport% + 5
OUT MixerReg%, cmd%
OUT MixerData%, value%
END SUB

