DECLARE SUB SBDETECT ()
DECLARE SUB RESETDSP ()
DECLARE SUB DMAPLAY (Segment&, Offset&, buflen&)
DECLARE SUB GetBLASTER (DMA, BasePort, IRQ)
DECLARE SUB WRITEDSP (ibyte)
DECLARE SUB PLAYMUSIC ()
COMMON SHARED repeat, buflen&
COMMON SHARED BasePort, LenPort, Channel, nosound
CONST timeconst = 256 - 1000000 \ 22050
'$DYNAMIC
DIM SHARED WavBuffer(0 TO 0) AS STRING * 32767
'$STATIC
DIM SHARED snds(1 TO 6) AS STRING * 30
DEF SEG
SBDETECT
IF nosound = 0 THEN
  GetBLASTER Channel, BasePort, IRQ
  RESETDSP
END IF
OPEN "dylan.wav" FOR BINARY AS #2
GET #2, , WavBuffer(0): buflen& = 32767
a! = LOF(2)
DO
IF nosound = 0 THEN PLAYMUSIC
aa! = aa! + 32767
LOOP UNTIL aa! >= a!
CLEAR
SYSTEM

SUB DMAPLAY (Segment&, Offset&, buflen&)
Page = 0
MemLoc& = Segment& * 16 + Offset&
SELECT CASE Channel
    CASE 0
       PgPort = &H87
       AddPort = &H0
       LenPort = &H1
       ModeReg = &H48
    CASE 1
       PgPort = &H83
       AddPort = &H2
       LenPort = &H3
       ModeReg = &H49
    CASE 2
       PgPort = &H81
       AddPort = &H4
       LenPort = &H5
       ModeReg = &H4A
    CASE 3
       PgPort = &H82
       AddPort = &H6
       LenPort = &H7
       ModeReg = &H4B
END SELECT
OUT &HA, &H4 + Channel
OUT &HC, &H0
OUT &HB, ModeReg
OUT AddPort, MemLoc& AND &HFF
OUT AddPort, (MemLoc& AND &HFFFF&) \ &H100
IF (MemLoc& AND 65536) THEN Page = Page + 1
IF (MemLoc& AND 131072) THEN Page = Page + 2
IF (MemLoc& AND 262144) THEN Page = Page + 4
IF (MemLoc& AND 524288) THEN Page = Page + 8
OUT PgPort, Page
OUT LenPort, buflen& AND &HFF
OUT LenPort, (buflen& AND &HFFFF&) \ &H100
OUT &HA, Channel
WRITEDSP &H40
WRITEDSP timeconst
WRITEDSP &H14
WRITEDSP (buflen& AND &HFF)
WRITEDSP ((buflen& AND &HFFFF&) \ &H100)
END SUB

SUB GetBLASTER (DMA, BasePort, IRQ)
IF LEN(ENVIRON$("BLASTER")) = 0 THEN PRINT "BLASTER environment variable not set.": EXIT SUB
FOR Length = 1 TO LEN(ENVIRON$("BLASTER"))
   SELECT CASE MID$(ENVIRON$("BLASTER"), Length, 1)
      CASE "A"
        BasePort = VAL("&H" + MID$(ENVIRON$("BLASTER"), Length + 1, 3))
      CASE "I"
        IRQ = VAL(MID$(ENVIRON$("BLASTER"), Length + 1, 1))
      CASE "D"
        DMA = VAL(MID$(ENVIRON$("BLASTER"), Length + 1, 1))
   END SELECT
NEXT
END SUB

SUB PLAYMUSIC
  DEF SEG
  RESETDSP
  IF repeat >= 0 THEN DMAPLAY VARSEG(WavBuffer(0)), VARPTR(WavBuffer(0)), buflen&
  IF EOF(2) THEN
    SEEK #2, 44
    IF repeat <= 0 THEN repeat = repeat - 1
  END IF
  buflen& = LOF(2) - LOC(2)
  IF buflen& > 32767 THEN buflen& = 32767
  GET #2, , WavBuffer(0)
END SUB

SUB RESETDSP
OUT BasePort + 6, 1
FOR Count = 1 TO 4
   junk = INP(BasePort + 6)
NEXT
OUT BasePort + 6, 0
END SUB

SUB SBDETECT
nosound = 1
FOR port = &H210 TO &H280 STEP &H10
  OUT port + &H6, 1
  FOR Count = 1 TO 100
    OUT port + &H6, 0
    Stat = INP(port + &HE)
    Stat = INP(port + &HA)
    IF Stat = &HAA THEN nosound = 0: EXIT SUB
  NEXT Count
NEXT port
IF nosound = 1 THEN
   PRINT "Sound Blaster not detected. Do you"
   PRINT "wish to disable sound? (y,n)"
   DO: sel$ = INKEY$: LOOP WHILE UCASE$(sel$) <> "Y" AND UCASE$(sel$) <> "N"
   IF UCASE$(sel$) = "N" THEN END
END IF
END SUB

SUB WRITEDSP (ibyte)
DO: LOOP WHILE INP(BasePort + 12) AND &H80
OUT BasePort + 12, ibyte
END SUB

