10 REM "Redhead" - a match game
20 ' List of variables
30 '         BOX     = Total number of matches in the box at any time
40 '         PLAYER  = The player whose turn it is to pick up matches
50 '         MATCHES = The number of matches picked up each turn
60 '         NUM     = Each match in the display stack
70 '         AGAIN$  = another game
80 '         K       = Timer loop counter
90 '
100 ' --------------------------------------
110 '                  Description and rules
120 ' --------------------------------------
130 CLEAR :CLS :KEY OFF
140 LOCATE  5,18
150 COLOR 14,  1 :PRINT "** The Game of ";
160 COLOR  4, 15 :PRINT "REDHEAD";
170 COLOR 14,  1 :PRINT " **"
180 LOCATE  8, 9
190 PRINT "Redhead is a match game between two players." :PRINT
200 PRINT TAB(9) "The two players are you and the computer." :PRINT
210 PRINT TAB(9) "A number of matches are in a box and the players"
220 PRINT TAB(9) "take turns to remove 1, 2 or 3 matches from the box."
230 PRINT TAB(9) "The player who has to pick up the last match is the loser."
240 ' --------------------------------------
250 '                 Getting ready - inputs
260 ' --------------------------------------
270 LOCATE 20, 9
280 PRINT "Press any key to start the game.";
290 Z$=INKEY$ :IF Z$="" THEN 290
300 CLEAR :CLS
310 LOCATE 10, 24
320 INPUT "How many matches are in the box ";BOX
330 IF BOX < 2 THEN PRINT :PRINT TAB(24); "Too few! Try again." :PRINT TAB(24);"";:GOTO 320
340 IF BOX > 23 THEN PRINT :PRINT TAB(24); "Maximum number for game is 23." :PRINT TAB(24);"";:GOTO 320
350 PRINT :PRINT TAB(24); "";
360 INPUT "Who goes first, you = 1 or the computer = 2 ";PLAYER
370 ' --------------------------------------
380 '                           Main program
390 ' --------------------------------------
400 CLS
410 GOSUB 900                               'to match-drawing subroutine
420 ON PLAYER GOSUB 610, 740                'to player subroutines
430 GOSUB 1040                              'time delay
440 CLS
450 BOX = BOX-MATCHES                       'current match total
460 GOSUB 900                               'to match-drawing subroutine
470 IF BOX > 1 THEN 420                     'next player
480 ' --------------------------------------
490 '                        Display results
500 ' --------------------------------------
510 GOSUB 1040                              'time delay
520 LOCATE  6,25
530 IF PLAYER = 1 THEN PRINT "The computer wins" ELSE PRINT "You win the game."
540 IF BOX = 0 THEN LOCATE 9,25 :PRINT "You took the lot! You are a silly mug."
550 GOSUB 1040                              'time delay
560 LOCATE 12,25
570 INPUT "Another game? YES OR NO ";AGAIN$
580 A$ = LEFT$(AGAIN$,1)
590 IF A$ = "Y" OR  A$ = "y" THEN 300 ELSE PRINT :PRINT "Game over" :END
600 ' --------------------------------------
610 '                Human player subroutine
620 ' --------------------------------------
630 PRINT TAB(25);"";:INPUT "How many matches do you want (1, 2 or 3) ";MATCHES
640 IF MATCHES > 3 OR MATCHES < 1 THEN 630 'check player's move
650 PRINT
660 PLAYER = 2                              'prepare for other player
670 IF MATCHES >= BOX THEN MATCHES = BOX :PLAYER = 1 'stay with present player
680 LOCATE  8,25
690 PRINT "You picked";MATCHES; "match";
700 IF MATCHES > 1 THEN PRINT "es"
710 PRINT
720 RETURN
730 ' --------------------------------------
740 '             Computer player subroutine
750 ' --------------------------------------
760 LOCATE  5,25
770 PRINT "It's the Computer's turn"
780 GOSUB 1040                              'time delay (simulate thinking)
790 MATCHES = ((BOX-1)/4 - INT((BOX-1)/4))*4             'computer strategy
800 IF MATCHES = 0 THEN LET MATCHES = INT(1 + 3*RND(1))  'best alternative
810 PLAYER = 1                              'prepare for other player
820 LOCATE  8,25
830 PRINT "The computer picked";MATCHES; "match";
840 IF MATCHES > 1 THEN PRINT "es"
850 PRINT
860 RETURN
870 ' --------------------------------------
880 '               Match-drawing subroutine
890 ' --------------------------------------
900 FOR NUM = 1 TO BOX
910   LOCATE 24-NUM,10                      'location of matches
920   COLOR  4,15
930   PRINT " *";                           'match head
940   COLOR  0,15
950   PRINT "======= "                      'match stick
960   COLOR 14, 1
970 NEXT NUM
980 LOCATE 23-B0X/2,25                      'location of text
990 PRINT "The box now contains";BOX;"match";
1000 IF BOX > 1 THEN PRINT "es"
1010 PRINT
1020 RETURN
1030 ' --------------------------------------
1040 '                  Time delay subroutine
1050 ' --------------------------------------
1060 FOR J = 1 TO 2000
1070   FOR K = 1 TO 2000
1080   NEXT K
1090 NEXT J
1100 RETURN