'Primality tests: test speed
'4 methods (well, two weels go for 1.5 so 3.5 methods)

'FUNCTION primeTrialDivision, requires nothing
'Trial division method, based on code by shanley06
'This is the simplest approach.

'Wheel factorisation. Thanks to link by Agual.
'FUNCTION primeSmallWheel, requires nothing
'Simple program

'FUNCTION primeBiggerWheel, uses some global arrays (initialised below)
'to store wheel data. Program becomes more complicated...
'probably this eats up supposed speed gain.

'FUNCTION primeEratosthenes, uses global array to store already found primes
'based on code by mgh730


DIM i AS INTEGER

'initialisation and code ------------

'wheel data for bigger wheel: 2,3,5
'3 base primes
DATA 3
DATA 2,3,5
'8 spokes
DATA 8
DATA 1, 7, 11, 13, 17, 19, 23, 29

'Wheel variables and initialisation ----------
COMMON SHARED NBase AS INTEGER, NSpokes AS INTEGER, modulo AS INTEGER

'--- COMMON statement for Eratosthenes-based algorithm - BASIC have me put it here
COMMON SHARED primeslength AS INTEGER

READ NBase
DIM SHARED basePrimes(NBase) AS LONG
FOR i = 1 TO NBase: READ basePrimes(i): NEXT i
READ NSpokes
DIM SHARED spokes(NSpokes) AS LONG
FOR i = 1 TO NSpokes: READ spokes(i): NEXT i
modulo = 1
FOR i = 1 TO NBase:  modulo = modulo * basePrimes(i): NEXT i
'--- end of wheel initialisation segment

'--- array for primes for Eratosthenes-based algorithm
DIM SHARED primes(2000) AS LONG  'It shows that it used 332 of them
primeslength = 0
primes(0) = 2


'test code starts here ----------------------------
CLS
PRINT "Primality tests: test for speed"
PRINT "(seconds for finding 1000 primes starting from 5000000)"
PRINT "4 methods. Please wait..."
PRINT

DIM number AS LONG
'if you want to see primes list, set wantToSeePrimes to 1
wantToSeePrimes = 0

method$ = "Trial Division"
PRINT method$; TAB(40);
i = 0
t = TIMER
FOR number = 5000000 TO 6000000
   IF primeTrialDivision(number) THEN
      IF wantToSeePrimes THEN PRINT number
      i = i + 1
   END IF
   IF i = 1000 THEN EXIT FOR
NEXT number
PRINT "Time: "; TIMER - t


method$ = "Wheel factorisation - small wheel"
PRINT method$; TAB(40);
i = 0
t = TIMER
FOR number = 5000000 TO 6000000
   IF primeSmallWheel(number) THEN
      IF wantToSeePrimes THEN PRINT number
      i = i + 1
   END IF
   IF i = 1000 THEN EXIT FOR
NEXT number
PRINT "Time: "; TIMER - t


method$ = "Wheel factorisation - bigger wheel"
PRINT method$; TAB(40);
i = 0
t = TIMER
FOR number = 5000000 TO 6000000
   IF primeBiggerWheel(number) THEN
      IF wantToSeePrimes THEN PRINT number
      i = i + 1
   END IF
   IF i = 1000 THEN EXIT FOR
NEXT number
PRINT "Time: "; TIMER - t


method$ = "sieve of Eratosthenes"
PRINT method$; TAB(40);
i = 0
t = TIMER
FOR number = 5000000 TO 6000000
   IF primeEratosthenes(number) THEN
      IF wantToSeePrimes THEN PRINT number
      i = i + 1
   END IF
   IF i = 1000 THEN EXIT FOR
NEXT number
PRINT "Time: "; TIMER - t


FUNCTION primeBiggerWheel (n AS LONG)
'wheel factorisation (as I got it)
'http://primes.utm.edu/glossary/page.php?sort=WheelFactorization
'bigger weel
'primes 2, 3, 5

DIM x AS LONG, xx AS LONG, sq AS LONG, i AS INTEGER

sq = SQR(n)
primeBiggerWheel = 1
'first check base primes
FOR i = 1 TO NBase
   IF (n MOD basePrimes(i)) = 0 THEN primeBiggerWheel = 0: EXIT FUNCTION
NEXT i

'then go by spoke
'first loop - special (don't want miss 1 or check for it every time)
FOR i = 2 TO NSpokes 'so skip spokes(1), that is 1
   IF (n MOD spokes(i)) = 0 THEN primeBiggerWheel = 0: EXIT FUNCTION
NEXT i

'main loop
x = modulo
DO
   FOR i = 1 TO NSpokes
      xx = x + spokes(i)
      IF xx > sq THEN EXIT FUNCTION
      IF (n MOD xx) = 0 THEN primeBiggerWheel = 0: EXIT FUNCTION
   NEXT i
   x = x + modulo
LOOP
END FUNCTION

FUNCTION primeEratosthenes (number AS LONG)
'sieve of Eratosthenes
'based by code by mgh730
   DIM max AS LONG, i AS LONG, j AS INTEGER
   max = SQR(number)
   'loop only to the square root
   primeEratosthenes = 1

   'first, check by stored numbers
   FOR j = 0 TO primeslength
      IF number MOD primes(j) = 0 THEN primeEratosthenes = 0: EXIT FUNCTION
   NEXT j

   'next check the rest
   FOR i = primes(primeslength) + 1 TO max
      isprime = 1
      FOR j = 0 TO primeslength
         IF i MOD primes(j) = 0 THEN isprime = 0: EXIT FOR
         'test against every prime before it
      NEXT j

      IF isprime = 1 THEN
         primeslength = primeslength + 1
         primes(primeslength) = i
         'store the prime number

         IF number MOD i = 0 THEN primeEratosthenes = 0: EXIT FUNCTION
         'test the number against the prime number
      END IF
   NEXT i
END FUNCTION

FUNCTION primeSmallWheel (n AS LONG)
'wheel factorisation (as I got it)
'http://primes.utm.edu/glossary/page.php?sort=WheelFactorization
'small weel
'primes 2 and 3. This would give us two spokes: 1 and 5

DIM x AS LONG, sq AS LONG
sq = SQR(n)
primeSmallWheel = 1
'first check base primes
IF (n MOD 2) = 0 THEN primeSmallWheel = 0: EXIT FUNCTION
IF (n MOD 3) = 0 THEN primeSmallWheel = 0: EXIT FUNCTION
'then go by spoke (1st and 5th in a table width 6)
x = 5
DO
   IF (n MOD x) = 0 THEN primeSmallWheel = 0: EXIT FUNCTION
   x = x + 2
   IF (n MOD x) = 0 THEN primeSmallWheel = 0: EXIT FUNCTION
   x = x + 4
LOOP UNTIL x > sq
END FUNCTION

FUNCTION primeTrialDivision (n AS LONG)
'based on code by shanley06
DIM x AS LONG
primeTrialDivision = 1
FOR x = 2 TO SQR(n)
   IF (n MOD x) = 0 THEN primeTrialDivision = 0: EXIT FUNCTION
NEXT x
END FUNCTION