'                QBasic Advanced Pong for the PC Version 2.0
'
'This program is similar to the original Pong game, where a ball bounced
'across the screen and the players used paddles to bounce the ball back and
'forth.  However, in the original Pong, players could only move up and down.
'In this game they can move left and right as well.  Also different from the
'original Pong game, the ball can be cradled in this game.  You will see what
'that means as you play the game.
'
'Controls:
'For Player 1, who is the blue paddle on the right, "8" is up, "2" is down,
'"6" is right, "4" is left, and "5" is the brake, which stops his movement.
'For Player 2, who is the red paddle on the left, "I" is up, "M" or "," is
'down, "L" is right, "J" is left, and "K" is the brake, which stops his movement.
'Press "F5" to start the game
'
'
'(More, press Page Down)
'If the game flickers too much, or goes too fast, make the number after
'"Flicker.Control =" bigger.  If the game goes too slow, make the number
'smaller.  Remember, on slower computers, there is always a trade-off
'between graphics quality and game speed.
Flicker.Control = 60000
'
'On some computers, the beep that this program does may slow down game play.
'If this is the case, make the number after "noise =" 0.  If you want the beep
'make the number 1.
noise = 0
'
'This is Version 2.0 of Advanced Pong for the PC, differing from Version 1.0
'in the fact that it's easier to control, and the graphics are slightly
'better.  Also, this version gives the user "Flicker.Control", and "noise",
'to allow the program to run better on their system.
'
'
'Programmed by Jeff Lewis
'
'
'
'
'
'

startover:
SCREEN 10

CLS
PRINT "What is the name of player 1?"
INPUT player1.name$
PRINT "What is the name of player 2?"
INPUT player2.name$
PRINT "How many rounds do you want to play?"
INPUT round.total
player1.score = 0
player2.score = 0
rounds = 0

new:
rounds = rounds + 1
     
'draw the field
SCREEN 7
CLS
PAINT (5, 5), (2)
LINE (0, 0)-(3, 199), 0, BF
LINE (0, 199)-(319, 194), 0, BF
LINE (318, 199)-(314, 0), 0, BF
PAINT (1, 1), (15), (2)
LINE (0, 0)-(0, 200), 0
LINE (1, 74)-(3, 144), 0, BF
LINE (314, 74)-(319, 144), 0, BF
LINE (1, 0)-(319, 20), 15, BF
LINE (0, 0)-(320, 15), 0, BF
LINE (317, 0)-(319, 199), 0, BF
LOCATE 1, 1
IF player1.score > player2.score THEN
COLOR 9
ELSE
COLOR 12
END IF

IF player1.score = player2.score THEN
COLOR 15
END IF

PRINT "Score:"; "   "; player2.name$; ":"; player2.score; "   "; player1.name$; ":"; player1.score

IF rounds > round.total THEN
GOTO quit
END IF

player1.x = 300
player1.y = 95
player2.x = 12
player2.y = 95
player1.move$ = "n"
player2.move$ = "n"
ball.x = 163
ball.y = 3 * INT(55 * RND) + 26

x = INT(2 * RND)
IF x = 1 THEN
ball.ns = 3
ELSE
ball.ns = -3
END IF

x = INT(2 * RND)
IF x = 1 THEN
ball.ew = 3
ELSE
ball.ew = -3
END IF

ball.x.2 = ball.x
ball.y.2 = ball.y
player1.x.2 = player1.x
player1.y.2 = player1.y
player2.x.2 = player2.x
player2.y.2 = player2.y

player1.ns = 0
player1.ew = 0
player2.ns = 0
player2.ew = 0

a:
CIRCLE (ball.x.2, ball.y.2), 6, 2
PAINT (ball.x.2, ball.y.2), (2), (2)

LINE (player1.x.2, player1.y.2 + 1)-(player1.x.2 + 6, player1.y.2 + 23), 2, BF
LINE (player2.x.2, player2.y.2 + 1)-(player2.x.2 + 6, player2.y.2 + 23), 2, BF

LINE (player1.x, player1.y + 1)-(player1.x + 6, player1.y + 23), 9, BF
LINE (player2.x, player2.y + 1)-(player2.x + 6, player2.y + 23), 12, BF
CIRCLE (ball.x, ball.y), 6, 14
PAINT (ball.x, ball.y), (14), (14)

FOR count = 1 TO Flicker.Control
NEXT count

ball.x.2 = ball.x
ball.y.2 = ball.y
player1.x.2 = player1.x
player1.y.2 = player1.y
player2.x.2 = player2.x
player2.y.2 = player2.y

ball.x = ball.x + ball.ew
ball.y = ball.y + ball.ns
player1.x = player1.x + player1.ew
player1.y = player1.y + player1.ns
player2.x = player2.x + player2.ew
player2.y = player2.y + player2.ns


IF ball.x - 6 <= 6 AND ball.y >= 74 AND ball.y <= 144 THEN
GOTO goal.1
END IF

IF ball.x + 6 >= 312 AND ball.y >= 74 AND ball.y <= 144 THEN
GOTO goal.2
END IF

IF ball.y - 6 <= 20 THEN
ball.ns = 3
END IF

IF ball.y + 6 >= 194 THEN
ball.ns = -3
END IF

IF ball.x - 6 <= 6 THEN
ball.ew = 3
END IF

IF ball.x + 6 >= 312 THEN
ball.ew = -3
END IF

IF ball.x + 6 >= player1.x AND ball.x - 6 <= player1.x + 6 AND ball.y >= player1.y AND ball.y <= player1.y + 24 THEN
ball.ew = -ball.ew
IF noise = 1 THEN
BEEP
END IF
END IF

IF ball.x + 6 >= player2.x AND ball.x - 6 <= player2.x + 6 AND ball.y >= player2.y AND ball.y <= player2.y + 24 THEN
ball.ew = -ball.ew
IF noise = 1 THEN
BEEP
END IF
END IF

IF player1.y <= 20 THEN
player1.ns = 3
END IF

IF player1.y + 24 >= 194 THEN
player1.ns = -3
END IF

IF player1.x <= 6 THEN
player1.ew = 3
END IF

IF player1.x + 6 >= 312 THEN
player1.ew = -3
END IF

IF player2.y <= 20 THEN
player2.ns = 3
END IF

IF player2.y + 24 >= 194 THEN
player2.ns = -3
END IF

IF player2.x <= 6 THEN
player2.ew = 3
END IF

IF player2.x + 6 >= 312 THEN
player2.ew = -3
END IF

move$ = INKEY$
SELECT CASE move$

CASE "p"
LOCATE 12, 3
COLOR 15
PRINT "Game Paused, Hit Space to Continue"
WHILE INKEY$ <> " "
WEND
LINE (10, 44)-(310, 144), 2, BF

CASE "q"
GOTO quit

'player1 change in movement
CASE "8"
player1.ns = -3

CASE "6"
player1.ew = 3

CASE "2"
player1.ns = 3

CASE "4"
player1.ew = -3

CASE "5"
player1.ew = 0
player1.ns = 0

'player2 change in movement
CASE "i"
player2.ns = -3

CASE "l"
player2.ew = 3

CASE ","
player2.ns = 3

CASE "m"
player2.ns = 3

CASE "j"
player2.ew = -3

CASE "k"
player2.ew = 0
player2.ns = 0

END SELECT

GOTO a

goal.1:
LOCATE 14, 2
COLOR 9
PRINT "Goal!"
player1.score = player1.score + 1
WHILE INKEY$ <> " "
WEND
GOTO new

goal.2:
COLOR 4
LOCATE 14, 35
PRINT "Goal!"
player2.score = player2.score + 1
WHILE INKEY$ <> " "
WEND
GOTO new

quit:
LOCATE 12, 6
COLOR 4
PRINT "           Game Over          "
LOCATE 13, 6
PRINT "Do you want to play again? y/n"
DO
y.n$ = INKEY$
LOOP UNTIL y.n$ = "y" OR y.n$ = "n"
IF y.n$ = "y" THEN
GOTO startover
END IF
