' GigaWave V1.02, Written by Benjamin Bahnsen
' Any comments, suggestions, etc. to gmbigb@aol.com
'
' SB-Autodetection by Alexander Verhaeghe
' WAVE-player originally by Mike Huff

REM $DYNAMIC
DECLARE SUB PlayWav (N%, a$, Status%)
DECLARE SUB SBAutoDetect ()
DECLARE FUNCTION DspRead% ()
DECLARE FUNCTION DspReset% ()
DECLARE SUB DSPWrite (Byte AS INTEGER)
DECLARE FUNCTION DMADone% ()
DIM SHARED SB.Baseport AS INTEGER, SB.IRQ AS INTEGER
DIM SHARED SB.LoDMA AS INTEGER, SB.HiDMA AS INTEGER
DIM SHARED SB.DSPMajor AS INTEGER, SB.DSPMinor AS INTEGER
DIM SHARED SB.Detected AS INTEGER, SB.LenPort AS INTEGER
DIM SHARED WavBuffer(1 TO 1) AS STRING * 32767

SBAutoDetect
Filename$ = "EXAMPLE.LIB"
CLS
PRINT "Welcome to GigaWave V1.02                                (w) Benjamin Bahnsen"
COLOR 9: PRINT "SBAutoDetect ";
COLOR 7: PRINT "found a soundblaster compatible soundcard at"
COLOR 13: PRINT "Baseport: "; HEX$(SB.Baseport) + "h";
COLOR 5: PRINT "   "; "IRQ:"; SB.IRQ;
COLOR 13: PRINT "   "; "Low-DMA:"; SB.LoDMA;
COLOR 5: PRINT "   "; "High-DMA:"; SB.HiDMA;
COLOR 13: PRINT "   DSP-Version:"; STR$(SB.DSPMinor) + "." + LTRIM$(STR$(SB.DSPMajor))
COLOR 7: PRINT
PRINT "Play every 8bit-Mono PCM-Wavefile. Maximum length is 32768 KByte!"
PRINT "First use QBWAV to add your wavefiles to a library, in Quickbasic just type"
COLOR 9: PRINT "CALL PlayWav(N%, Filename$, Status%)"
COLOR 7: PRINT "to play wavefile number N% from library Filename$"
COLOR 9: PRINT "PlayWav "; : COLOR 7: PRINT "returns"
COLOR 13: PRINT "Status% = 0, "; : COLOR 5: PRINT "if the wavefile if smaller then 32KB"
COLOR 13: PRINT "Status% = 1, "; : COLOR 5: PRINT "if the wavefile is bigger than 32KB. In this case, you"
PRINT "             need to call PlayWav again and again, until Status% = 0"
COLOR 13: PRINT : PRINT "Press any key to play a small wavefile";
WHILE INKEY$ = "": WEND

N% = 2: CALL PlayWav(N%, Filename$, Status%)

LOCATE , 1: PRINT "Now press any key to play a long wavefile"
WHILE INKEY$ = "": WEND

N% = 1: CALL PlayWav(N%, Filename$, Status%)

COLOR 9: PRINT "WHILE Status% = 1"
PRINT "    Call PlayWav(N%, Filename$, Status%)"
COLOR 7: PRINT "    ...": PRINT "    ... do what you want ..."
PRINT "    ...": COLOR 9: PRINT "WEND"

X% = 26: T! = TIMER
WHILE Status% = 1
CALL PlayWav(N%, Filename$, Status%)
COLOR INT(RND * 15): LOCATE 18, X%: PRINT " It's playing in the background "
IF TIMER - T! > .1 THEN
  T! = TIMER
  IF T% = 0 THEN
             X% = X% + 1: IF X% = 45 THEN T% = 1
             ELSE
             X% = X% - 1: IF X% = 26 THEN T% = 0
  END IF
END IF
WEND
LOCATE 22, 1: COLOR 7
PRINT "Wait with DMADone% until the wavefile has finished playing"
COLOR 9: PRINT "WHILE NOT DMADone%: WEND";
WHILE NOT DMADone%: WEND
COLOR 7: PRINT " ---> Finished."
END

REM $STATIC
DEFINT A-Z
FUNCTION DMADone%
SHARED SB.LenPort AS INTEGER
Count% = INP(SB.LenPort)
Count2% = INP(SB.LenPort)
Count& = CLNG(Count% + 1) * CLNG(Count2% + 1)
IF (Count& - 1) >= &HFFFF& THEN junk% = INP(DSPDataAvail%): DMADone% = -1
END FUNCTION

FUNCTION DspRead
  SHARED SB.Baseport AS INTEGER
  DO
  LOOP UNTIL INP(SB.Baseport + &HE) AND &H80
  DspRead = INP(SB.Baseport + &HA)
END FUNCTION

FUNCTION DspReset%
  SHARED SB.Baseport AS INTEGER
  DIM ct AS INTEGER, stat AS INTEGER
  OUT SB.Baseport + &H6, &H1
  FOR ct = 1 TO 100
  NEXT ct
  OUT SB.Baseport + &H6, &H0
  ct = 0
  stat = 0
  WHILE (stat <> &HAA) AND (ct < 100)
    stat = INP(SB.Baseport + &HE)
    stat = INP(SB.Baseport + &HA)
    ct = ct + 1
  WEND
  IF stat = &HAA THEN DspReset% = 0 ELSE DspReset% = -1
END FUNCTION

SUB DSPWrite (Byte AS INTEGER)
  SHARED SB.Baseport AS INTEGER
  DO
  LOOP UNTIL (INP(SB.Baseport + &HC) AND &H80) = 0
  OUT SB.Baseport + &HC, Byte
END SUB

DEFSNG A-Z
SUB PlayWav (WAV AS INTEGER, Filename$, Status AS INTEGER) STATIC
DIM Libposition AS STRING * 4, Samplerate AS STRING * 2
DIM Lengthofdata AS STRING * 4
SHARED SB.Baseport AS INTEGER
SHARED SB.LoDMA AS INTEGER
SHARED SB.HiDMA AS INTEGER
SHARED SB.IRQ AS INTEGER
SHARED SB.DSPMajor AS INTEGER
SHARED SB.DSPMinor AS INTEGER
SHARED SB.Detected AS INTEGER
SHARED SB.LenPort AS INTEGER
SHARED WavBuffer() AS STRING * 32767
IF SB.Baseport = 0 THEN EXIT SUB
OPEN Filename$ FOR BINARY AS #2
IF WAV = OldWav% THEN
   IF CutLength& > 1 THEN
      IF DMADone% THEN  ELSE CLOSE #2: EXIT SUB
      BytePos& = CutPos&: Length& = CutLength&: GOTO Continue
      ELSE
      GOTO Continue: REM If Status=1 : CLOSE #2: EXIT SUB
   END IF
END IF
a% = DspReset
V& = WAV * 32 + 1
GET #2, V&, Libposition
GET #2, V& + 4, Samplerate
GET #2, V& + 6, Lengthofdata
DEF SEG = VARSEG(Freq&): V& = VARPTR(Freq&)
POKE V&, ASC(LEFT$(Samplerate, 1)): POKE V& + 1, ASC(RIGHT$(Samplerate, 1))
DEF SEG = VARSEG(Length&): V& = VARPTR(Length&)
FOR I% = 1 TO 4: POKE V& + I% - 1, ASC(MID$(Lengthofdata, I%, 1)): NEXT I%
DEF SEG = VARSEG(BytePos&): V& = VARPTR(BytePos&)
FOR I% = 1 TO 4: POKE V& + I% - 1, ASC(MID$(Libposition, I%, 1)): NEXT I%
Continue:
GET #2, BytePos&, WavBuffer(1): CLOSE #2
IF Length& > 32000 THEN
      CutLength& = Length& - 32000
      CutPos& = BytePos& + 32000
      Length& = 32000
      Status = 1
      ELSE
      Status = 0
      CutLength& = 0
END IF
Length& = Length& - 1: Page% = 0
Segment& = VARSEG(WavBuffer(1)): Offset& = VARPTR(WavBuffer(1))
MemLoc& = Segment& * 16 + Offset&
SELECT CASE SB.LoDMA
  CASE 0: PgPort% = &H87: AddPort% = &H0: SB.LenPort = &H1: ModeReg% = &H48
  CASE 1: PgPort% = &H83: AddPort% = &H2: SB.LenPort = &H3: ModeReg% = &H49
  CASE 2: PgPort% = &H81: AddPort% = &H4: SB.LenPort = &H5: ModeReg% = &H4A
  CASE 3: PgPort% = &H82: AddPort% = &H6: SB.LenPort = &H7: ModeReg% = &H4B
END SELECT
OUT &HA, &H4 + SB.LoDMA: OUT &HC, &H0
OUT &HB, ModeReg%: OUT AddPort%, MemLoc& AND &HFF
OUT AddPort%, (MemLoc& AND &HFFFF&) \ &H100
IF (MemLoc& AND 65536) THEN Page% = Page% + 1
IF (MemLoc& AND 131072) THEN Page% = Page% + 2
IF (MemLoc& AND 262144) THEN Page% = Page% + 4
IF (MemLoc& AND 524288) THEN Page% = Page% + 8
OUT PgPort%, Page%: OUT SB.LenPort, Length& AND &HFF
OUT SB.LenPort, (Length& AND &HFFFF&) \ &H100: OUT &HA, SB.LoDMA
TimeConst% = 256 - 1000000 \ Freq&
DSPWrite &H40
DSPWrite TimeConst%
DSPWrite &H14
DSPWrite (Length& AND &HFF)
DSPWrite ((Length& AND &HFFFF&) \ &H100)
OldWav% = WAV
END SUB

DEFINT A-Z
SUB SBAutoDetect
SHARED SB.Baseport AS INTEGER
SHARED SB.LoDMA AS INTEGER
SHARED SB.HiDMA AS INTEGER
SHARED SB.IRQ AS INTEGER
SHARED SB.DSPMajor AS INTEGER
SHARED SB.DSPMinor AS INTEGER
SHARED SB.Detected AS INTEGER
  REM  Check all baseports to search for soundblaster
  SB.Baseport = &H220: SBDetected = -1
  WHILE (SB.Baseport <= &H280) AND (SBDetected = -1)
    SBDetected = DspReset
    IF SBDetected = -1 THEN SB.Baseport = SB.Baseport + &H20
  WEND
 
  IF SBDetected = 0 THEN
     REM  Autodetect IRQ
     OUT SB.Baseport + &H4, &H80
     SELECT CASE INP(SB.Baseport + &H5) AND &HF
     CASE &H1: SB.IRQ = 2
     CASE &H2: SB.IRQ = 5
     CASE &H4: SB.IRQ = 7
     CASE &H8: SB.IRQ = 10
     CASE ELSE: SB.IRQ = -1
     END SELECT
     REM  Autodetect LowerDMA
     OUT SB.Baseport + &H4, &H81
     SELECT CASE INP(SB.Baseport + &H5) AND &HB
     CASE &H1: SB.LoDMA = 0
     CASE &H2: SB.LoDMA = 1
     CASE &H8: SB.LoDMA = 3
     CASE ELSE: SB.LoDMA = -1
     END SELECT
     REM  Autodetect UpperDMA
     OUT SB.Baseport + &H4, &H81
     SELECT CASE INP(SB.Baseport + &H5) \ &H20
     CASE &H1: SB.HiDMA = 5
     CASE &H2: SB.HiDMA = 6
     CASE &H4: SB.HiDMA = 7
     CASE ELSE: SB.HiDMA = SB.LoDMA
     END SELECT
     REM  Autodetect DSPVersion
     DSPWrite &HE1
     SB.DSPMajor = DspRead: SB.DSPMinor = DspRead
END IF

END SUB

